#!/bin/bash -e

# Helper script to install the packages required by DSS in an externally-managed Python installation
# Call with the PIP_COMMAND as first argument
#
# The actual packages are in $DKUINSTALLDIR/resources/builtin-python-env/dss-server
#
# This is not actually used in normal operation, and is only for guidance. In normal operation, the 
# builtin env packages are provided as part of the kit and are only referenced by the builtin env.
#
# The following files should always be reviewed together when touching the builtin env
#    packagers/studio/scripts/install/install-python-packages.sh
#    packagers/studio/scripts/install/install-python-packages.ps1
#    packagers/fm/scripts/install/install-python-packages.sh
#    resources/container-exec/install-builtin-env-python-packages.sh
#    resources/builtin-python-env/dss-server
#    resources/builtin-python-env/container-images
#    packagers/resource-build/python (ultimately run/built by Patrice)
# In addition, make sure to keep it in sync with the various files in resources/code-envs/python

Usage() {
  echo "Usage: $0 PIP_COMMAND" >&2
  exit 1
}

if [ $# -eq 0 ]; then
  Usage
fi
pip="$1"
if [ "$pip" = ":" ]; then
  # Special tricks for Jenkins CI, Python version is passed directly as 2nd parameter
  pythonVersion="$2"
else
  # Grab Python version from "pip -V" output
  pipVersion=$($pip -V)
  pythonVersion=$(sed -n 's/^pip .* (python \([0-9]\.[0-9]*\))$/\1/p' <<<"$pipVersion")
  if [ -z "$pythonVersion" ]; then
    echo >&2 "*** Error: could not retrieve python version"
    exit 1
  fi
fi

if [ -z "$DKUINSTALLDIR" ]; then
  # Fall back to location-base detection if not specified by the environment
  MYDIR=$(cd "$(dirname "$0")" && pwd -P)
  DKUINSTALLDIR=$(dirname "$(dirname "$MYDIR")")
fi

case "$pythonVersion" in
   "3.9")
    requirementsFile="$DKUINSTALLDIR/resources/builtin-python-env/dss-server/requirements-py39.txt"
    ;;
   "3.10")
    requirementsFile="$DKUINSTALLDIR/resources/builtin-python-env/dss-server/requirements-py310.txt"
    ;;
   "3.11")
    requirementsFile="$DKUINSTALLDIR/resources/builtin-python-env/dss-server/requirements-py311.txt"
    ;;
  *)
    echo >&2 "*** Error: python version not supported: $pythonVersion"
    exit 1
esac

echo "+ Upgrading pip"
$pip install --upgrade pip wheel

echo "+ Installing required Python packages ..."
$pip install -r "$requirementsFile"

# Remove stuff installed only temporarily
echo "+ Cleaning up ..."
$pip uninstall -y notebook jupyterlab-widgets


# # For tracking - not in the builtin env anymore
# REMOVED_DEPS="
# patsy>=0.5,<0.6
# bokeh>=0.12.10,<0.13
# bkcharts>=0.2,<0.3
# seaborn>=0.9,<0.10
# "
