/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

class AsyncHealthCheckDecorator
extends HealthCheck
implements Runnable {
    private static final String NO_RESULT_YET_MESSAGE = "Waiting for first asynchronous check result.";
    private final HealthCheck healthCheck;
    private final ScheduledFuture<?> future;
    private volatile HealthCheck.Result result;

    AsyncHealthCheckDecorator(HealthCheck healthCheck, ScheduledExecutorService executorService) {
        this.check(healthCheck != null, "healthCheck cannot be null");
        this.check(executorService != null, "executorService cannot be null");
        Async async = healthCheck.getClass().getAnnotation(Async.class);
        this.check(async != null, "healthCheck must contain Async annotation");
        this.check(async.period() > 0L, "period cannot be less than or equal to zero");
        this.check(async.initialDelay() >= 0L, "initialDelay cannot be less than zero");
        this.healthCheck = healthCheck;
        this.result = Async.InitialState.HEALTHY.equals((Object)async.initialState()) ? HealthCheck.Result.healthy(NO_RESULT_YET_MESSAGE) : HealthCheck.Result.unhealthy(NO_RESULT_YET_MESSAGE);
        this.future = Async.ScheduleType.FIXED_RATE.equals((Object)async.scheduleType()) ? executorService.scheduleAtFixedRate(this, async.initialDelay(), async.period(), async.unit()) : executorService.scheduleWithFixedDelay(this, async.initialDelay(), async.period(), async.unit());
    }

    @Override
    public void run() {
        this.result = this.healthCheck.execute();
    }

    @Override
    protected HealthCheck.Result check() throws Exception {
        return this.result;
    }

    boolean tearDown() {
        return this.future.cancel(true);
    }

    HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

