/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core;

import com.google.common.collect.ImmutableSet;
import com.twitter.hbc.core.Constants;
import com.twitter.hbc.core.endpoint.Endpoint;
import com.twitter.hbc.httpclient.auth.Authentication;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class HttpConstants {
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final Set<Integer> FATAL_CODES = ImmutableSet.of((Object)404, (Object)406, (Object)413, (Object)416);

    public static boolean checkHttpMethod(String httpMethod) {
        if (httpMethod.equalsIgnoreCase(HTTP_GET)) {
            return true;
        }
        return httpMethod.equalsIgnoreCase(HTTP_POST);
    }

    public static boolean isValidHttpScheme(String address) {
        return address.toLowerCase().equalsIgnoreCase(HTTP_SCHEME) || address.toLowerCase().equalsIgnoreCase(HTTPS_SCHEME);
    }

    public static HttpUriRequest constructRequest(String host, Endpoint endpoint, Authentication auth) {
        String url = host + endpoint.getURI();
        if (endpoint.getHttpMethod().equalsIgnoreCase(HTTP_GET)) {
            HttpGet get = new HttpGet(url);
            if (auth != null) {
                auth.signRequest((HttpUriRequest)get, null);
            }
            return get;
        }
        if (endpoint.getHttpMethod().equalsIgnoreCase(HTTP_POST)) {
            HttpPost post = new HttpPost(url);
            post.setEntity((HttpEntity)new StringEntity(endpoint.getPostParamString(), Constants.DEFAULT_CHARSET));
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            if (auth != null) {
                auth.signRequest((HttpUriRequest)post, endpoint.getPostParamString());
            }
            return post;
        }
        throw new IllegalArgumentException("Bad http method: " + endpoint.getHttpMethod());
    }

    public class Codes {
        public static final int SUCCESS = 200;
        public static final int UNAUTHORIZED = 401;
        public static final int FORBIDDEN = 403;
        public static final int UNKNOWN = 404;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int PARAMETER_LIST_TOO_LONG = 413;
        public static final int RANGE_UNACCEPTABLE = 416;
        public static final int RATE_LIMITED = 420;
        public static final int SERVICE_UNAVAILABLE = 503;
    }
}

