/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okio;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.kotlin.jvm.internal.Intrinsics;
import io.trino.jdbc.$internal.okio.Buffer;
import io.trino.jdbc.$internal.okio.DeflaterSink;
import io.trino.jdbc.$internal.okio.RealBufferedSink;
import io.trino.jdbc.$internal.okio.Segment;
import io.trino.jdbc.$internal.okio.Sink;
import io.trino.jdbc.$internal.okio.Timeout;
import io.trino.jdbc.$internal.okio.internal._ZlibJvmKt;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0011\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0007\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\u00060\nj\u0002`\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/trino/jdbc/$internal/okio/GzipSink;", "Lio/trino/jdbc/$internal/okio/Sink;", "sink", "(Lokio/Sink;)V", "closed", "", "crc", "Ljava/util/zip/CRC32;", "Lio/trino/jdbc/$internal/okio/internal/CRC32;", "deflater", "Ljava/util/zip/Deflater;", "Lio/trino/jdbc/$internal/okio/Deflater;", "()Ljava/util/zip/Deflater;", "deflaterSink", "Lio/trino/jdbc/$internal/okio/DeflaterSink;", "Lio/trino/jdbc/$internal/okio/RealBufferedSink;", "close", "", "-deprecated_deflater", "flush", "timeout", "Lio/trino/jdbc/$internal/okio/Timeout;", "updateCrc", "buffer", "Lio/trino/jdbc/$internal/okio/Buffer;", "byteCount", "", "write", "source", "writeFooter", "io.trino.jdbc.$internal.okio"})
@.SourceDebugExtension(value={"SMAP\nGzipSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipSink.kt\nokio/GzipSink\n+ 2 RealBufferedSink.kt\nokio/RealBufferedSink\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,152:1\n51#2:153\n1#3:154\n86#4:155\n*S KotlinDebug\n*F\n+ 1 GzipSink.kt\nokio/GzipSink\n*L\n62#1:153\n130#1:155\n*E\n"})
public final class GzipSink
implements Sink {
    @NotNull
    private final RealBufferedSink sink;
    @NotNull
    private final Deflater deflater;
    @NotNull
    private final DeflaterSink deflaterSink;
    private boolean closed;
    @NotNull
    private final CRC32 crc;

    public GzipSink(@NotNull Sink sink2) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        this.sink = new RealBufferedSink(sink2);
        this.deflater = new Deflater(_ZlibJvmKt.getDEFAULT_COMPRESSION(), true);
        this.deflaterSink = new DeflaterSink(this.sink, this.deflater);
        this.crc = new CRC32();
        RealBufferedSink this_$iv = this.sink;
        boolean $i$f$getBuffer = false;
        Buffer $this$_init__u24lambda_u240 = buffer = this_$iv.bufferField;
        boolean bl = false;
        $this$_init__u24lambda_u240.writeShort(8075);
        $this$_init__u24lambda_u240.writeByte(8);
        $this$_init__u24lambda_u240.writeByte(0);
        $this$_init__u24lambda_u240.writeInt(0);
        $this$_init__u24lambda_u240.writeByte(0);
        $this$_init__u24lambda_u240.writeByte(0);
    }

    @.JvmName(name="deflater")
    @NotNull
    public final Deflater deflater() {
        return this.deflater;
    }

    @Override
    public void write(@NotNull Buffer source2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (byteCount == 0L) {
            return;
        }
        this.updateCrc(source2, byteCount);
        this.deflaterSink.write(source2, byteCount);
    }

    @Override
    public void flush() throws IOException {
        this.deflaterSink.flush();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                thrown = null;
                try {
                    this.deflaterSink.finishDeflate$okio();
                    this.writeFooter();
                }
                catch (Throwable e) {
                    thrown = e;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable e) {
                    if (thrown != null) break block8;
                    thrown = e;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block9;
                thrown = e;
            }
        }
        this.closed = true;
        Throwable throwable = thrown;
        if (throwable != null) {
            throw throwable;
        }
    }

    private final void writeFooter() {
        this.sink.writeIntLe((int)this.crc.getValue());
        this.sink.writeIntLe((int)this.deflater.getBytesRead());
    }

    private final void updateCrc(Buffer buffer, long byteCount) {
        int segmentLength;
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment head = segment;
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)segmentLength) {
            int b$iv = head.limit - head.pos;
            boolean $i$f$minOf = false;
            segmentLength = (int)Math.min(remaining, (long)b$iv);
            this.crc.update(head.data, head.pos, segmentLength);
            Intrinsics.checkNotNull(head.next);
        }
    }

    @.Deprecated(message="moved to val", replaceWith=@.ReplaceWith(expression="deflater", imports={}), level=.DeprecationLevel.ERROR)
    @.JvmName(name="-deprecated_deflater")
    @NotNull
    public final Deflater -deprecated_deflater() {
        return this.deflater;
    }
}

