/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIIgnore;
import com.dataiku.j2ts.annotations.UIType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PartitioningScheme
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean ignoreNonMatchingFile = false;
    private String filePathPattern;
    @UIIgnore
    private final List<String> dimensionNames = new ArrayList<String>();
    @UIType(value="Dimension[]", manualImports={Dimension.class})
    private final Map<String, Dimension> dimensions = new HashMap<String, Dimension>();
    public boolean considerMissingRequestedPartitionsAsEmpty;

    public boolean isPartitioned() {
        return this.dimensions.size() > 0;
    }

    public PartitioningScheme addDimension(Dimension dimension) {
        this.dimensionNames.add(dimension.getName());
        this.dimensions.put(dimension.getName(), dimension);
        return this;
    }

    public boolean isEqual(PartitioningScheme other) {
        if (!other.dimensionNames.equals(this.dimensionNames)) {
            return false;
        }
        for (String dimensionName : this.dimensionNames) {
            if (other.dimensions.get(dimensionName).equals(this.dimensions.get(dimensionName))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isEqual((PartitioningScheme)obj);
    }

    public int hashCode() {
        return 0;
    }

    public List<String> getDimensionNames() {
        return this.dimensionNames;
    }

    public List<DimensionType> getDimensionTypes() {
        return this.dimensions.values().stream().map(Dimension::toDimensionType).collect(Collectors.toList());
    }

    Map<String, Dimension> getDimensions() {
        return this.dimensions;
    }

    public Set<String> getDimensionNamesSet() {
        return this.dimensions.keySet();
    }

    public Dimension getDimension(String name) {
        return this.dimensions.get(name);
    }

    public boolean isSingleDimension() {
        return this.dimensionNames.size() == 1;
    }

    public Dimension getSingleDimension() {
        Preconditions.checkState((this.dimensionNames.size() == 1 ? 1 : 0) != 0);
        return this.dimensions.get(this.dimensionNames.get(0));
    }

    public TimeDimension getSingleTimeDimension() {
        for (Dimension dim : this.dimensions.values()) {
            if (!(dim instanceof TimeDimension)) continue;
            return (TimeDimension)dim;
        }
        return null;
    }

    public String getFilePathPattern() {
        return this.filePathPattern;
    }

    public void setFilePathPattern(String filePathPattern) {
        this.filePathPattern = filePathPattern;
    }

    public PartitioningScheme withFilePathPattern(String filePathPattern) {
        this.filePathPattern = filePathPattern;
        return this;
    }

    public boolean getIgnoreNonMatchingFile() {
        return this.ignoreNonMatchingFile;
    }

    public void setIgnoreNonMatchingFile(boolean ignoreNonMatchingFile) {
        this.ignoreNonMatchingFile = ignoreNonMatchingFile;
    }

    public boolean getConsiderMissingRequestedPartitionsAsEmpty() {
        return this.considerMissingRequestedPartitionsAsEmpty;
    }

    public void setConsiderMissingRequestedPartitionsAsEmpty(boolean considerMissingRequestedPartitionsAsEmpty) {
        this.considerMissingRequestedPartitionsAsEmpty = considerMissingRequestedPartitionsAsEmpty;
    }

    public String describe() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String dimName : this.dimensionNames) {
            Dimension dim = this.dimensions.get(dimName);
            if (dim instanceof TimeDimension) {
                list.add(dimName + " (" + String.valueOf((Object)((TimeDimension)dim).mappedPeriod) + ")");
                continue;
            }
            list.add(dimName);
        }
        return StringUtils.join(list, (String)", ");
    }

    public static void registerJsonAdapter() {
        JSON.registerAdapter(PartitioningScheme.class, (Object)new JSON.Adapter<PartitioningScheme>(){

            public PartitioningScheme deserialize(JsonElement elt, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject json = elt.getAsJsonObject();
                PartitioningScheme scheme = new PartitioningScheme();
                if (json.has("filePathPattern")) {
                    scheme.setFilePathPattern(json.get("filePathPattern").getAsString());
                }
                if (json.has("ignoreNonMatchingFile")) {
                    scheme.setIgnoreNonMatchingFile(json.get("ignoreNonMatchingFile").getAsBoolean());
                }
                if (json.has("considerMissingRequestedPartitionsAsEmpty")) {
                    scheme.setConsiderMissingRequestedPartitionsAsEmpty(json.get("considerMissingRequestedPartitionsAsEmpty").getAsBoolean());
                }
                if (json.has("dimensions")) {
                    List dimensions = (List)ctx.deserialize((JsonElement)json.get("dimensions").getAsJsonArray(), new TypeToken<List<Dimension>>(){}.getType());
                    for (Dimension dimension : dimensions) {
                        scheme.addDimension(dimension);
                    }
                }
                return scheme;
            }

            public JsonElement serialize(PartitioningScheme scheme, Type type, JsonSerializationContext ctx) {
                JsonObject json = new JsonObject();
                json.addProperty("filePathPattern", scheme.getFilePathPattern());
                json.addProperty("ignoreNonMatchingFile", Boolean.valueOf(scheme.getIgnoreNonMatchingFile()));
                json.addProperty("considerMissingRequestedPartitionsAsEmpty", Boolean.valueOf(scheme.getConsiderMissingRequestedPartitionsAsEmpty()));
                ArrayList dimensions = Lists.newArrayList();
                for (String dimensionName : scheme.getDimensionNames()) {
                    dimensions.add(scheme.getDimension(dimensionName));
                }
                json.add("dimensions", ctx.serialize((Object)dimensions, new TypeToken<List<Dimension>>(){}.getType()));
                return json;
            }
        });
    }

    public static PartitioningScheme createTimePartitioningScheme(TimeDimension.Period partitioningPeriod) {
        PartitioningScheme partitioningScheme = new PartitioningScheme();
        partitioningScheme.addDimension(new TimeDimension("time", partitioningPeriod));
        switch (partitioningPeriod) {
            case DAY: {
                partitioningScheme.setFilePathPattern("/%Y/%M/%D/.*");
                break;
            }
            case HOUR: {
                partitioningScheme.setFilePathPattern("/%Y/%M/%D/%H/.*");
                break;
            }
            case MONTH: {
                partitioningScheme.setFilePathPattern("/%Y/%M/.*");
                break;
            }
            case YEAR: {
                partitioningScheme.setFilePathPattern("/%Y/.*");
            }
        }
        return partitioningScheme;
    }
}

