/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class ReadOnlyFSBase
implements ReadOnlyFS {
    private void dumpHelper(StringBuilder sb, RelFile rf, int level) throws IOException {
        String leaf = rf.getLeafName();
        if (leaf.isEmpty()) {
            leaf = "/";
        }
        if (this.isFile(rf)) {
            sb.append(StringUtils.repeat((String)"    ", (int)level) + " - " + leaf + "\n");
        } else if (this.isDirectory(rf)) {
            sb.append(StringUtils.repeat((String)"    ", (int)level) + " + " + leaf + "\n");
            for (RelFile crf : this.listFiles(rf)) {
                this.dumpHelper(sb, crf, level + 1);
            }
        }
    }

    @Override
    public List<RelFile> listFiles(String path) throws IOException {
        return this.listFiles(RelFile.fromPath(path));
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.isFile(RelFile.fromPath(path));
    }

    @Override
    public boolean isFile(RelFile file) throws IOException {
        RelFileAttribute attributes = this.getAttributes(file);
        return attributes != null && attributes.getFileType() == RelFileAttribute.FileType.FILE;
    }

    @Override
    public boolean isDirectory(RelFile file) throws IOException {
        RelFileAttribute attributes = this.getAttributes(file);
        return attributes != null && attributes.getFileType() == RelFileAttribute.FileType.DIRECTORY;
    }

    @Override
    public long getLength(RelFile file) throws IOException {
        RelFileAttribute attributes = this.getAttributes(file);
        if (attributes == null || attributes.getFileType() != RelFileAttribute.FileType.FILE) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        return attributes.getLength();
    }

    @Override
    public long getLastModified(RelFile file) throws IOException {
        RelFileAttribute attributes = this.getAttributes(file);
        if (attributes == null || attributes.getFileType() != RelFileAttribute.FileType.FILE) {
            throw new IOException(String.valueOf(file) + " is not a file");
        }
        return attributes.getLastModified();
    }

    @Override
    public RelFileInputStream readStream(String path) throws IOException {
        return this.readStream(RelFile.fromPath(path));
    }

    @Override
    public RelFileInputStream readStream(RelFile file) throws IOException {
        return new RelFileInputStream(file, this.readContentUnsafe(file).getAsNewStream());
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.isDirectory(RelFile.fromPath(path));
    }

    @Override
    public String dumpTree() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.dumpHelper(sb, new RelFile(new String[0]), 0);
        return sb.toString();
    }

    private void listRecursive(RelFile root, RelFileFilter filter, List<RelFile> out) throws IOException {
        if (!filter.accept(this, root)) {
            return;
        }
        RelFileAttribute attrs = this.getAttributes(root);
        if (attrs == null) {
            return;
        }
        if (attrs.getFileType() == RelFileAttribute.FileType.FILE) {
            out.add(root);
        } else if (attrs.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
            out.add(root);
            for (RelFile rf : this.listFiles(root)) {
                this.listRecursive(rf, filter, out);
            }
        } else {
            throw new IOException(String.valueOf(root) + " seems to exist but is neither a file or a directory");
        }
    }

    @Override
    public List<RelFile> listRecursive(RelFile file, RelFileFilter filter) throws IOException {
        ArrayList<RelFile> out = new ArrayList<RelFile>();
        this.listRecursive(file, filter, out);
        return out;
    }

    @Override
    public List<RelFile> listRecursive(String path, RelFileFilter filter) throws IOException {
        return this.listRecursive(RelFile.fromPath(path), filter);
    }

    @Override
    public List<RelFile> listRecursive(RelFile file) throws IOException {
        return this.listRecursive(file, (RelFileFilter)new AcceptAllFilter());
    }

    @Override
    public List<RelFile> listRecursive(String path) throws IOException {
        return this.listRecursive(RelFile.fromPath(path));
    }

    @Override
    public boolean exists(RelFile file) throws IOException {
        return this.getAttributes(file) != null;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.exists(RelFile.fromPath(path));
    }

    @Override
    public List<RelFile> listFiles(RelFile directory) throws IOException {
        List<RelFile> files = this.listFilesUnordered(directory);
        Collections.sort(files);
        return files;
    }

    @Override
    public byte[] getHash(String path) throws IOException {
        return this.getHash(RelFile.fromPath(path));
    }

    @Override
    public byte[] getHash(RelFile file) throws IOException {
        FileContent fileContent = this.readContentUnsafe(file);
        return fileContent.getHash();
    }

    @Override
    public List<RelFile> listFiles(RelFile directory, RelFileFilter filter) throws IOException {
        ArrayList<RelFile> filteredFiles = null;
        List<RelFile> allFiles = this.listFiles(directory);
        if (filter == null) {
            return allFiles;
        }
        int length = allFiles.size();
        for (int i = 0; i < length; ++i) {
            RelFile file = allFiles.get(i);
            if (filter.accept(this, file)) {
                if (filteredFiles == null) continue;
                filteredFiles.add(file);
                continue;
            }
            if (filteredFiles != null) continue;
            filteredFiles = new ArrayList<RelFile>(i);
            for (int j = 0; j < i; ++j) {
                filteredFiles.add(allFiles.get(j));
            }
        }
        return filteredFiles == null ? allFiles : filteredFiles;
    }

    @Override
    public List<RelFile> listFiles(String path, RelFileFilter filter) throws IOException {
        return this.listFiles(RelFile.fromPath(path), filter);
    }

    @Override
    public long getLastModified(String path) throws IOException {
        return this.getLastModified(RelFile.fromPath(path));
    }

    @Override
    public long getLength(String path) throws IOException {
        return this.getLength(RelFile.fromPath(path));
    }

    @Override
    public <T> T readObjectUnsafe(RelFile file, Class<T> clazz) throws IOException {
        return this.readContentUnsafe(file).getAsObject(clazz);
    }

    @Override
    public ReadOnlyFS.CompressedFileData readCompressedBytesUnsafe(RelFile file) throws IOException {
        FileContent fileContent = this.readContentUnsafe(file);
        return fileContent.getCompressedFileData();
    }

    @Override
    public String readStringUTF8(RelFile file) throws IOException {
        return this.readContentUnsafe(file).getAsString();
    }

    @Override
    public <T> T readObject(RelFile file, Class<T> clazz) throws IOException {
        return this.readContentUnsafe(file).getAsNewObject(clazz);
    }

    @Override
    public <T> T readObject(String path, Class<T> clazz) throws IOException {
        return this.readObject(RelFile.fromPath(path), clazz);
    }

    @Override
    public String readStringUTF8(String path) throws IOException {
        return this.readStringUTF8(RelFile.fromPath(path));
    }

    @Override
    public <T> T readObjectUnsafe(String path, Class<T> clazz) throws IOException {
        return this.readObjectUnsafe(RelFile.fromPath(path), clazz);
    }

    @Override
    public byte[] readBytes(RelFile file) throws IOException {
        return this.readContentUnsafe(file).getAsNewBytes();
    }

    @Override
    public byte[] readBytes(String path) throws IOException {
        return this.readBytes(RelFile.fromPath(path));
    }

    @Override
    public <T> T readObjectDefault(String path, Class<T> clazz) throws IOException {
        return this.readObjectDefault(RelFile.fromPath(path), clazz);
    }

    @Override
    public <T> T readObjectDefaultUnsafe(String path, Class<T> clazz) throws IOException {
        return this.readObjectDefaultUnsafe(RelFile.fromPath(path), clazz);
    }

    @Override
    public <T> T readObjectDefaultUnsafe(RelFile file, Class<T> clazz) throws IOException {
        return this.readObjectDefaultImpl(file, clazz, false);
    }

    @Override
    public <T> T readObjectDefault(RelFile file, Class<T> clazz) throws IOException {
        return this.readObjectDefaultImpl(file, clazz, true);
    }

    private <T> T readObjectDefaultImpl(RelFile file, Class<T> clazz, boolean safe) throws IOException {
        T obj;
        FileContent content = null;
        RelFileAttribute attributes = this.getAttributes(file);
        if (attributes != null) {
            if (attributes.getFileType() == RelFileAttribute.FileType.FILE) {
                content = this.readContentUnsafe(file);
            } else if (attributes.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                throw new IOException(String.valueOf(file) + " is a directory");
            }
        }
        if (content != null && (obj = safe ? content.getAsNewObject(clazz) : content.getAsObject(clazz)) != null) {
            return obj;
        }
        try {
            Constructor<T> ctor = clazz.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Unable to default construct " + clazz.getCanonicalName(), e);
        }
    }
}

