/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.AutoCloseableLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class NamedLock
extends ReentrantLock {
    private static final long serialVersionUID = 1L;
    private int lockCounter = 0;
    private static final Map<String, NamedLock> index = new HashMap<String, NamedLock>();

    private NamedLock() {
    }

    private LockInfo dumpInfo() {
        return new LockInfo(this.getOwner(), this.isLocked());
    }

    private static synchronized NamedLock incrementCounter(String name) {
        NamedLock lock = index.computeIfAbsent(name, n -> new NamedLock());
        ++lock.lockCounter;
        return lock;
    }

    private static synchronized void decrementCounter(String name) {
        NamedLock lock = index.get(name);
        if (lock == null) {
            throw new IllegalStateException(String.format("Lock (%s) is no longer in the index", name));
        }
        if (lock.lockCounter <= 0) {
            throw new IllegalStateException(String.format("Lock (%s) counter is too low: %d", name, lock.lockCounter));
        }
        --lock.lockCounter;
        if (lock.lockCounter == 0) {
            index.remove(name);
        }
    }

    public static synchronized Map<String, LockInfo> dumpAcquiredLocksInfo() {
        HashMap<String, LockInfo> infoByName = new HashMap<String, LockInfo>();
        index.forEach((name, lock) -> infoByName.put((String)name, lock.dumpInfo()));
        return infoByName;
    }

    public static synchronized boolean isHeldByCurrentThread(String name) {
        return index.containsKey(name) && index.get(name).isHeldByCurrentThread();
    }

    public static AutoCloseableLock acquire(String name) {
        NamedLock lock = NamedLock.incrementCounter(name);
        lock.lock();
        return () -> NamedLock.release(name);
    }

    public static AutoCloseableLock acquireInterruptibly(String name) throws InterruptedException {
        NamedLock lock = NamedLock.incrementCounter(name);
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            NamedLock.decrementCounter(name);
            throw e;
        }
        return () -> NamedLock.release(name);
    }

    private static void release(String name) {
        NamedLock lock = NamedLock.incrementCounter(name);
        try {
            lock.unlock();
            NamedLock.decrementCounter(name);
        }
        finally {
            NamedLock.decrementCounter(name);
        }
    }

    public static class LockInfo {
        public final Thread owner;
        public final boolean isLocked;

        public LockInfo(Thread owner, boolean isLocked) {
            this.owner = owner;
            this.isLocked = isLocked;
        }
    }
}

