/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClassLoaderPool {
    private static Logger logger = Logger.getLogger(ClassLoaderPool.class);
    private HashMap<String, String[]> collections = new HashMap();
    private LinkedHashMap<Set<String>, List<URLClassLoader>> pool = new LinkedHashMap();
    private IdentityHashMap<URLClassLoader, Set<String>> currentlyUsed = new IdentityHashMap();

    public synchronized ClassLoader requirePooled(String ... collectionNames) {
        logger.info((Object)("Require class loader (" + StringUtils.join((Object[])collectionNames, (String)"+") + ")"));
        HashSet<String> set = new HashSet<String>(Arrays.asList(collectionNames));
        List<URLClassLoader> clList = this.pool.get(set);
        URLClassLoader cl = null;
        if (clList != null) {
            if (clList.size() > 0) {
                logger.info((Object)("Reuse existing class loader (" + StringUtils.join((Object[])collectionNames, (String)"+") + ")"));
                cl = clList.remove(clList.size() - 1);
            } else {
                cl = this.requireNew(collectionNames);
            }
        } else {
            cl = this.requireNew(collectionNames);
        }
        this.currentlyUsed.put(cl, set);
        this.logInternalState();
        return cl;
    }

    private synchronized void logInternalState() {
        logger.info((Object)"Declared JAR collections:");
        for (Map.Entry<String, String[]> entry : this.collections.entrySet()) {
            logger.info((Object)("  > " + entry.getKey() + " (" + entry.getValue().length + " jar(s))"));
        }
        logger.info((Object)"Currently used classloaders:");
        for (Map.Entry<Object, Object> entry : this.currentlyUsed.entrySet()) {
            logger.info((Object)("  > classloader for collections [" + StringUtils.join((Collection)((Collection)entry.getValue()), (String)"+") + "]"));
        }
        logger.info((Object)"Pool content:");
        for (Map.Entry<Object, Object> entry : this.pool.entrySet()) {
            logger.info((Object)("  > for collections [" + StringUtils.join((Collection)((Collection)entry.getKey()), (String)"+") + "] : " + ((List)entry.getValue()).size() + " classloader(s)"));
        }
    }

    public synchronized void release(ClassLoader cl) {
        Set<String> collect = this.currentlyUsed.get(cl);
        if (collect != null) {
            logger.info((Object)("Release class loader (" + StringUtils.join(collect, (String)"+") + ")"));
            List<URLClassLoader> clList = this.pool.get(collect);
            if (clList != null) {
                clList.add((URLClassLoader)cl);
            } else {
                clList = new ArrayList<URLClassLoader>();
                clList.add((URLClassLoader)cl);
                this.pool.put(collect, clList);
            }
        } else {
            logger.warn((Object)"Released a class loader that was NOT created withing this pool !");
            if (cl instanceof URLClassLoader) {
                try {
                    ((URLClassLoader)cl).close();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to close classloader", (Throwable)e);
                }
            }
        }
        this.logInternalState();
    }

    public synchronized URLClassLoader requireNew(String ... collectionNames) {
        logger.info((Object)("Create new class loader (" + StringUtils.join((Object[])collectionNames, (String)"+") + ")"));
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String collectionName : collectionNames) {
            String[] collection = this.collections.get(collectionName);
            if (collection == null) {
                throw new RuntimeException("Jar collection \"" + collectionName + "\" has not been declared");
            }
            for (String jarPath : this.collections.get(collectionName)) {
                File file;
                if (StringUtils.isBlank((String)jarPath) || !(file = new File(jarPath)).exists()) continue;
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
    }

    public synchronized void addJarCollection(String name, String[] jars) throws FileNotFoundException {
        logger.info((Object)("Declared new JAR collection \"" + name + "\":"));
        for (String jar : jars) {
            if ((jar = jar.trim()).isEmpty()) continue;
            logger.info((Object)(" > " + jar));
            if (new File(jar).exists()) continue;
            throw new FileNotFoundException("Cannot find : " + jar);
        }
        this.collections.put(name, (String[])jars.clone());
    }
}

