/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.notifications.TemplateContext;
import com.dataiku.gh.core.models.notifications.common.ArtifactTemplateContext;
import com.dataiku.gh.core.models.notifications.common.UserTemplateContext;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class NotificationContext
extends TemplateContext {
    protected String ghUrl;
    protected Map<String, EnrichedArtifact> subscriptionReasons;
    protected ArtifactTemplateContext notificationArtifactContext;

    public String getEmailTemplatePath() {
        return this.getEmailTemplateFolder() + this.getEmailTemplateFilename();
    }

    public List<ArtifactTemplateContext> getArtifactContextsToEnrichWithBreadcrumb() {
        return Collections.emptyList();
    }

    public List<TemplateContext> getChildren() {
        return this.notificationArtifactContext == null ? Collections.emptyList() : Collections.singletonList(this.notificationArtifactContext);
    }

    public void setNotificationArtifact(EnrichedArtifact notificationArtifact) {
        this.notificationArtifactContext = new ArtifactTemplateContext(notificationArtifact);
    }

    public void setGhUrl(String ghUrl) {
        this.ghUrl = ghUrl;
    }

    public SimpleHash buildTemplateModel() {
        EnrichedArtifact subscriptionReasonArtifact;
        SimpleHash model = new SimpleHash((ObjectWrapper)WRAPPER_BUILDER.build());
        UserTemplateContext notificationRecipientContext = new UserTemplateContext(this.userLogin);
        notificationRecipientContext.enrichWithUsers(this.users);
        if (this.notificationArtifactContext != null) {
            model.put("notificationArtifact", (Object)this.notificationArtifactContext.buildTemplateModel());
        }
        if (this.subscriptionReasons != null && (subscriptionReasonArtifact = this.subscriptionReasons.get(this.userLogin)) != null) {
            ArtifactTemplateContext subscriptionReasonArtifactContext = new ArtifactTemplateContext(subscriptionReasonArtifact);
            subscriptionReasonArtifactContext.enrichWithUsers(this.users);
            subscriptionReasonArtifactContext.enrichWithPermissions(this.permissionMapping);
            subscriptionReasonArtifactContext.enrichWithCurrentUserLogin(this.userLogin);
            model.put("subscriptionReasonArtifact", (Object)subscriptionReasonArtifactContext.buildTemplateModel());
        }
        model.put("notificationRecipient", (Object)notificationRecipientContext.buildTemplateModel());
        model.put("ghUrl", (Object)this.ghUrl);
        return model;
    }

    public void enrichWithSubscriptionReasons(Map<String, EnrichedArtifact> subscriptionReasons) {
        this.subscriptionReasons = subscriptionReasons;
    }

    public abstract boolean userShouldReceiveNotification();

    protected abstract String getEmailTemplateFolder();

    protected abstract String getEmailTemplateFilename();
}

