/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.signoff;

import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.visitors.ISignoffVisitor;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Signoff {
    public SignoffId signoffId;
    public int cycleIndex;
    public SignoffConfiguration configuration;
    public SignoffStatus status;
    @UINullable
    public SignoffStatus statusBeforeAbandoned;
    public String statusDate;
    @UINullable
    public String feedbackRequesterIdentifier;
    @UINullable
    public String feedbackRequestDate;
    @UINullable
    public String approvalRequesterIdentifier;
    @UINullable
    public String approvalRequestDate;
    public List<SignoffFeedback> feedbackResponses = new ArrayList<SignoffFeedback>();
    @UINullable
    public SignoffApproval approverResponse;

    public void accept(ISignoffVisitor visitor) {
        this.configuration.accept(visitor);
        this.feedbackResponses.forEach(response -> response.accept(visitor));
        if (this.approverResponse != null) {
            this.approverResponse.accept(visitor);
        }
        visitor.visit(this);
    }

    public SignoffId getSignoffId() {
        return this.signoffId;
    }

    public void updateStatus(SignoffStatus status) {
        Objects.requireNonNull(status, "Status is required");
        if (status != this.status) {
            this.statusBeforeAbandoned = SignoffStatus.ABANDONED.equals((Object)status) ? this.status : null;
            this.status = status;
            this.statusDate = DateUtils.now();
        }
    }

    public boolean isBlocking() {
        return this.configuration.mandatory && this.status != SignoffStatus.APPROVED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signoff signoff = (Signoff)o;
        return this.cycleIndex == signoff.cycleIndex && Objects.equals(this.signoffId, signoff.signoffId) && Objects.equals(this.configuration, signoff.configuration) && this.status == signoff.status && this.statusBeforeAbandoned == signoff.statusBeforeAbandoned && Objects.equals(this.statusDate, signoff.statusDate) && Objects.equals(this.feedbackResponses, signoff.feedbackResponses) && Objects.equals(this.approverResponse, signoff.approverResponse);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signoffId, this.cycleIndex, this.configuration, this.status, this.statusBeforeAbandoned, this.statusDate, this.feedbackResponses, this.approverResponse});
    }

    public static enum SignoffStatus {
        NOT_STARTED,
        WAITING_FOR_FEEDBACK,
        WAITING_FOR_APPROVAL,
        APPROVED,
        REJECTED,
        ABANDONED;


        public static SignoffStatus from(SignoffApproval.SignoffApprovalStatus approvalStatus) {
            switch (approvalStatus) {
                case APPROVED: {
                    return APPROVED;
                }
                case REJECTED: {
                    return REJECTED;
                }
                case ABANDONED: {
                    return ABANDONED;
                }
            }
            throw new IllegalStateException(String.format("Unable to map the approval status '%s' to a sign-off status", new Object[]{approvalStatus}));
        }

        public boolean isRunning() {
            return Sets.newHashSet((Object[])new SignoffStatus[]{WAITING_FOR_FEEDBACK, WAITING_FOR_APPROVAL}).contains((Object)this);
        }

        public boolean acceptsFeedback() {
            return Sets.newHashSet((Object[])new SignoffStatus[]{WAITING_FOR_FEEDBACK}).contains((Object)this);
        }

        public boolean acceptsApproval() {
            return Sets.newHashSet((Object[])new SignoffStatus[]{WAITING_FOR_APPROVAL}).contains((Object)this);
        }

        public boolean acceptsApprovalEdition() {
            return Sets.newHashSet((Object[])new SignoffStatus[]{APPROVED, REJECTED, ABANDONED}).contains((Object)this);
        }

        public boolean acceptsFeedbackDelegation() {
            return Sets.newHashSet((Object[])new SignoffStatus[]{NOT_STARTED, WAITING_FOR_FEEDBACK}).contains((Object)this);
        }

        public boolean acceptsApprovalDelegation() {
            return Sets.newHashSet((Object[])new SignoffStatus[]{NOT_STARTED, WAITING_FOR_FEEDBACK, WAITING_FOR_APPROVAL}).contains((Object)this);
        }
    }
}

