/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.enriched.EnrichedDeletedArtifact;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.ReferenceFieldDefinition;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.models.roles.assignments.RoleAssignmentsRule;
import com.dataiku.gh.core.models.roles.assignments.criteria.Criterion;
import com.dataiku.gh.core.models.roles.audit.RolesAndPermissionsAudit;
import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.security.UsersContainer;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUserBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.RoleAssignmentsComputationUtils;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.visitors.HierarchicalFieldDefinitionVisitor;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBlueprintRoleAssignmentsComputationService
implements IUserBlueprintRoleAssignmentsComputationService {
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.blueprint-role-assignments-computation");

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtBlueprintLevel(AuthCtx authCtx, EnrichedBlueprint enrichedBlueprint) throws IOException {
        RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit = RolesAndPermissionsAudit.RolesAssignmentsAudit.buildAtBlueprintLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedBlueprint);
        return this.computeRolesAtBlueprintLevel(authCtx, enrichedBlueprint, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtBlueprintLevel(AuthCtx authCtx, EnrichedBlueprint enrichedBlueprint, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        Set<String> cachedRoles = UserRolesCacheContext.getBlueprintLevelRolesOrNull(enrichedBlueprint.blueprint.id);
        if (cachedRoles != null) {
            return cachedRoles;
        }
        RolesComputationContext context = new RolesComputationContext();
        this.preAssemblageRolesComputationAtBlueprintLevel(authCtx, context, enrichedBlueprint, rolesAssignmentsAudit);
        if (UserRolesCacheContext.hasContext()) {
            this.assembleAllRolesWithInheritanceAndFillCache(context);
            return Optional.ofNullable(UserRolesCacheContext.getBlueprintLevelRolesOrNull(enrichedBlueprint.blueprint.id)).orElseThrow(() -> new IllegalStateException("Roles computation has failed at blueprint level: " + enrichedBlueprint.blueprint.id));
        }
        return this.assembleRolesWithInheritanceAtBlueprintLevel(context, enrichedBlueprint.blueprint.id);
    }

    private void preAssemblageRolesComputationAtBlueprintLevel(AuthCtx authCtx, RolesComputationContext context, EnrichedBlueprint enrichedBlueprint, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate = RoleAssignmentsComputationUtils::doCriterionComplyAtBlueprintLevel;
        Set<String> selfRolesIds = this.computeRolesFromRules(enrichedBlueprint.blueprintRoleAssignments, null, criterionPredicate, authCtx, null, rolesAssignmentsAudit);
        RolesComputationContext.RolesComputationResult currentRolesComputationResult = RolesComputationContext.RolesComputationResult.build(selfRolesIds);
        context.bpLevel.put(enrichedBlueprint.blueprint.id, currentRolesComputationResult);
        this.handleBlueprintInheritance(authCtx, context, currentRolesComputationResult, enrichedBlueprint.blueprintRoleAssignments, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtBlueprintVersionLevel(AuthCtx authCtx, EnrichedBlueprintVersion enrichedBlueprintVersion) throws IOException {
        RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit = RolesAndPermissionsAudit.RolesAssignmentsAudit.buildAtBlueprintVersionLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedBlueprintVersion);
        return this.computeRolesAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtBlueprintVersionLevel(AuthCtx authCtx, EnrichedBlueprintVersion enrichedBlueprintVersion, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        Set<String> cachedRoles = UserRolesCacheContext.getBlueprintVersionLevelRolesOrNull(enrichedBlueprintVersion.blueprintVersion.id);
        if (cachedRoles != null) {
            return cachedRoles;
        }
        RolesComputationContext context = new RolesComputationContext();
        this.preAssemblageRolesComputationAtBlueprintVersionLevel(authCtx, context, enrichedBlueprintVersion, rolesAssignmentsAudit);
        if (UserRolesCacheContext.hasContext()) {
            this.assembleAllRolesWithInheritanceAndFillCache(context);
            return Optional.ofNullable(UserRolesCacheContext.getBlueprintVersionLevelRolesOrNull(enrichedBlueprintVersion.blueprintVersion.id)).orElseThrow(() -> new IllegalStateException("Roles computation has failed at blueprint version level: " + String.valueOf(enrichedBlueprintVersion.blueprintVersion.id)));
        }
        return this.assembleRolesWithInheritanceAtBlueprintVersionLevel(context, enrichedBlueprintVersion.blueprintVersion.id);
    }

    private void preAssemblageRolesComputationAtBlueprintVersionLevel(AuthCtx authCtx, RolesComputationContext context, EnrichedBlueprintVersion enrichedBlueprintVersion, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate = (criterion, audit) -> RoleAssignmentsComputationUtils.doCriterionComplyAtBlueprintVersionLevel(criterion, enrichedBlueprintVersion, audit);
        Set<String> selfRolesIds = this.computeRolesFromRules(enrichedBlueprintVersion.blueprintRoleAssignments, null, criterionPredicate, authCtx, null, rolesAssignmentsAudit);
        RolesComputationContext.RolesComputationResult currentRolesComputationResult = RolesComputationContext.RolesComputationResult.build(selfRolesIds);
        context.bpvLevel.put(enrichedBlueprintVersion.blueprintVersion.id, currentRolesComputationResult);
        this.handleBlueprintInheritance(authCtx, context, currentRolesComputationResult, enrichedBlueprintVersion.blueprintRoleAssignments, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtArtifactExistingLevel(AuthCtx authCtx, EnrichedArtifact enrichedArtifact) throws IOException {
        RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit = RolesAndPermissionsAudit.RolesAssignmentsAudit.buildAtArtifactExistingLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedArtifact);
        return this.computeRolesAtArtifactExistingLevel(authCtx, enrichedArtifact, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtArtifactExistingLevel(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        Set<String> cachedRoles = UserRolesCacheContext.getArtifactExistingLevelRolesOrNull(enrichedArtifact.artifact.id);
        if (cachedRoles != null) {
            return cachedRoles;
        }
        RolesComputationContext context = new RolesComputationContext();
        this.preAssemblageRolesComputationAtArtifactExistingLevel(authCtx, context, enrichedArtifact, rolesAssignmentsAudit);
        if (UserRolesCacheContext.hasContext()) {
            this.assembleAllRolesWithInheritanceAndFillCache(context);
            return Optional.ofNullable(UserRolesCacheContext.getArtifactExistingLevelRolesOrNull(enrichedArtifact.artifact.id)).orElseThrow(() -> new IllegalStateException("Roles computation has failed at artifact existing level: " + enrichedArtifact.artifact.id));
        }
        return this.assembleRolesWithInheritanceAtArtifactExistingLevel(context, enrichedArtifact.artifact.id);
    }

    private void preAssemblageRolesComputationAtArtifactExistingLevel(AuthCtx authCtx, RolesComputationContext context, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate = (criterion, audit) -> RoleAssignmentsComputationUtils.doCriterionComplyAtExistingArtifactLevel(criterion, enrichedArtifact, audit);
        Set<String> selfRolesIds = this.computeRolesFromRules(enrichedArtifact.blueprintRoleAssignments, enrichedArtifact.artifactRoleAssignments, criterionPredicate, authCtx, enrichedArtifact, rolesAssignmentsAudit);
        RolesComputationContext.RolesComputationResult currentRolesComputationResult = RolesComputationContext.RolesComputationResult.build(selfRolesIds);
        context.artifactExistingLevel.put(enrichedArtifact.artifact.id, currentRolesComputationResult);
        this.handleBlueprintInheritance(authCtx, context, currentRolesComputationResult, enrichedArtifact.blueprintRoleAssignments, rolesAssignmentsAudit);
        this.handleArtifactInheritance(authCtx, context, currentRolesComputationResult, enrichedArtifact, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtArtifactDeletedLevel(AuthCtx authCtx, EnrichedDeletedArtifact enrichedDeletedArtifact) throws IOException {
        RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit = RolesAndPermissionsAudit.RolesAssignmentsAudit.buildAtArtifactDeletedLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedDeletedArtifact);
        return this.computeRolesAtArtifactDeletedLevel(authCtx, enrichedDeletedArtifact, rolesAssignmentsAudit);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> computeRolesAtArtifactDeletedLevel(AuthCtx authCtx, EnrichedDeletedArtifact enrichedDeletedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        String artifactId = enrichedDeletedArtifact.lastKnownEnrichedArtifact.artifact.id;
        Set<String> cachedRoles = UserRolesCacheContext.getArtifactDeletedLevelRolesOrNull(artifactId);
        if (cachedRoles != null) {
            return cachedRoles;
        }
        RolesComputationContext context = new RolesComputationContext();
        this.preAssemblageRolesComputationAtArtifactDeletedLevel(authCtx, context, enrichedDeletedArtifact, rolesAssignmentsAudit);
        if (UserRolesCacheContext.hasContext()) {
            this.assembleAllRolesWithInheritanceAndFillCache(context);
            return Optional.ofNullable(UserRolesCacheContext.getArtifactDeletedLevelRolesOrNull(artifactId)).orElseThrow(() -> new IllegalStateException("Roles computation has failed at artifact deleted level: " + artifactId));
        }
        return this.assembleRolesWithInheritanceAtArtifactDeletedLevel(context, artifactId);
    }

    private void preAssemblageRolesComputationAtArtifactDeletedLevel(AuthCtx authCtx, RolesComputationContext context, EnrichedDeletedArtifact enrichedDeletedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate = (criterion, audit) -> RoleAssignmentsComputationUtils.doCriterionComplyAtArtifactDeletedLevel(criterion, enrichedDeletedArtifact.lastKnownEnrichedArtifact.blueprintVersion.id, audit);
        Set<String> selfRolesIds = this.computeRolesFromRules(enrichedDeletedArtifact.currentEnrichedBlueprint != null ? enrichedDeletedArtifact.currentEnrichedBlueprint.blueprintRoleAssignments : null, enrichedDeletedArtifact.currentArtifactRoleAssignments, criterionPredicate, authCtx, null, rolesAssignmentsAudit);
        RolesComputationContext.RolesComputationResult currentRolesComputationResult = RolesComputationContext.RolesComputationResult.build(selfRolesIds);
        context.artifactDeletedLevel.put(enrichedDeletedArtifact.lastKnownEnrichedArtifact.artifact.id, currentRolesComputationResult);
        if (enrichedDeletedArtifact.currentEnrichedBlueprint != null) {
            this.handleBlueprintInheritance(authCtx, context, currentRolesComputationResult, enrichedDeletedArtifact.currentEnrichedBlueprint.blueprintRoleAssignments, rolesAssignmentsAudit);
        }
    }

    private void handleBlueprintInheritance(AuthCtx authCtx, RolesComputationContext context, RolesComputationContext.RolesComputationResult currentRolesComputationResult, @Nullable BlueprintRoleAssignments blueprintRoleAssignments, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        if (blueprintRoleAssignments == null || CollectionUtils.isEmpty(blueprintRoleAssignments.inheritBlueprintIds)) {
            return;
        }
        for (String inheritBlueprintId : blueprintRoleAssignments.inheritBlueprintIds) {
            RolesAndPermissionsAudit.BlueprintInheritanceLookupAudit blueprintInheritanceLookupAudit = rolesAssignmentsAudit.blueprintsInheritanceLookupAudit.addBlueprintInheritanceLookupAudit(inheritBlueprintId);
            if (StringUtils.isBlank((CharSequence)inheritBlueprintId)) continue;
            Set<String> cachedRoles = UserRolesCacheContext.getBlueprintLevelRolesOrNull(inheritBlueprintId);
            if (cachedRoles != null) {
                currentRolesComputationResult.inheritBlueprintIds.add(inheritBlueprintId);
                blueprintInheritanceLookupAudit.inheritanceValidAndFound = true;
                RolesComputationContext.RolesComputationResult cachedRolesComputationResult = RolesComputationContext.RolesComputationResult.build(cachedRoles);
                context.bpLevel.put(inheritBlueprintId, cachedRolesComputationResult);
                continue;
            }
            if (context.bpLevel.get(inheritBlueprintId) != null) {
                currentRolesComputationResult.inheritBlueprintIds.add(inheritBlueprintId);
                blueprintInheritanceLookupAudit.inheritanceValidAndFound = true;
                continue;
            }
            EnrichedBlueprint inheritEnrichedBlueprint = this.blueprintsDataService.getBlueprintOrNull(inheritBlueprintId);
            boolean bl = blueprintInheritanceLookupAudit.inheritanceValidAndFound = inheritEnrichedBlueprint != null;
            if (inheritEnrichedBlueprint == null) continue;
            RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsBlueprintInheritanceAudit = rolesAssignmentsAudit.addBlueprintInheritance(inheritBlueprintId);
            currentRolesComputationResult.inheritBlueprintIds.add(inheritBlueprintId);
            this.preAssemblageRolesComputationAtBlueprintLevel(authCtx, context, inheritEnrichedBlueprint, rolesAssignmentsBlueprintInheritanceAudit);
        }
    }

    private void handleArtifactInheritance(AuthCtx authCtx, RolesComputationContext context, RolesComputationContext.RolesComputationResult currentRolesComputationResult, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        Set<String> inheritArtifactIds = RoleAssignmentsComputationUtils.getInheritArtifactIds(enrichedArtifact, rolesAssignmentsAudit.artifactsInheritanceLookupAudit);
        if (CollectionUtils.isEmpty(inheritArtifactIds)) {
            return;
        }
        for (String inheritArtifactId : inheritArtifactIds) {
            RolesAndPermissionsAudit.ArtifactInheritanceLookupAudit artifactInheritanceLookupAudit = rolesAssignmentsAudit.artifactsInheritanceLookupAudit.addArtifactInheritanceAudit(inheritArtifactId);
            Set<String> cachedRoles = UserRolesCacheContext.getArtifactExistingLevelRolesOrNull(inheritArtifactId);
            if (cachedRoles != null) {
                currentRolesComputationResult.inheritArtifactIds.add(inheritArtifactId);
                artifactInheritanceLookupAudit.inheritanceValidAndFound = true;
                RolesComputationContext.RolesComputationResult cachedRolesComputationResult = RolesComputationContext.RolesComputationResult.build(cachedRoles);
                context.artifactExistingLevel.put(inheritArtifactId, cachedRolesComputationResult);
                continue;
            }
            if (context.artifactExistingLevel.get(inheritArtifactId) != null) {
                currentRolesComputationResult.inheritArtifactIds.add(inheritArtifactId);
                artifactInheritanceLookupAudit.inheritanceValidAndFound = true;
                continue;
            }
            EnrichedArtifact inheritEnrichedArtifact = this.artifactsDataService.getArtifactOrNull(inheritArtifactId);
            boolean bl = artifactInheritanceLookupAudit.inheritanceValidAndFound = inheritEnrichedArtifact != null;
            if (inheritEnrichedArtifact == null) continue;
            RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsArtifactInheritanceAudit = rolesAssignmentsAudit.addArtifactInheritance(inheritArtifactId);
            currentRolesComputationResult.inheritArtifactIds.add(inheritArtifactId);
            this.preAssemblageRolesComputationAtArtifactExistingLevel(authCtx, context, inheritEnrichedArtifact, rolesAssignmentsArtifactInheritanceAudit);
        }
    }

    private void assembleAllRolesWithInheritanceAndFillCache(RolesComputationContext context) {
        context.bpLevel.forEach((bpId, rc) -> {
            Set<String> roles = this.assembleRolesWithInheritanceAtBlueprintLevel(context, (String)bpId);
            UserRolesCacheContext.addBlueprintLevelRoles(bpId, roles);
        });
        context.bpvLevel.forEach((bpvId, rc) -> {
            Set<String> roles = this.assembleRolesWithInheritanceAtBlueprintVersionLevel(context, (BlueprintVersionId)bpvId);
            UserRolesCacheContext.addBlueprintVersionLevelRoles(bpvId, roles);
        });
        context.artifactExistingLevel.forEach((artifactId, rc) -> {
            Set<String> roles = this.assembleRolesWithInheritanceAtArtifactExistingLevel(context, (String)artifactId);
            UserRolesCacheContext.addArtifactExistingLevelRoles(artifactId, roles);
        });
        context.artifactDeletedLevel.forEach((artifactId, rc) -> {
            Set<String> roles = this.assembleRolesWithInheritanceAtArtifactDeletedLevel(context, (String)artifactId);
            UserRolesCacheContext.addArtifactDeletedLevelRoles(artifactId, roles);
        });
    }

    private Set<String> assembleRolesWithInheritanceAtBlueprintLevel(RolesComputationContext context, String blueprintId) {
        return this.assembleRolesWithInheritanceAtBlueprintLevel(context, blueprintId, Sets.newHashSet((Object[])new String[]{blueprintId}));
    }

    private Set<String> assembleRolesWithInheritanceAtBlueprintLevel(RolesComputationContext context, String blueprintId, Set<String> visitedBlueprintIds) {
        RolesComputationContext.RolesComputationResult computationForBP = context.bpLevel.get(blueprintId);
        HashSet<String> rolesWithInheritance = new HashSet<String>(computationForBP.selfRoles);
        for (String inheritBlueprintId : computationForBP.inheritBlueprintIds) {
            if (inheritBlueprintId == null || visitedBlueprintIds.contains(inheritBlueprintId)) continue;
            visitedBlueprintIds.add(inheritBlueprintId);
            rolesWithInheritance.addAll(this.assembleRolesWithInheritanceAtBlueprintLevel(context, inheritBlueprintId, visitedBlueprintIds));
        }
        return rolesWithInheritance;
    }

    private Set<String> assembleRolesWithInheritanceAtBlueprintVersionLevel(RolesComputationContext context, BlueprintVersionId blueprintVersionId) {
        RolesComputationContext.RolesComputationResult rc = context.bpvLevel.get(blueprintVersionId);
        HashSet<String> roles = new HashSet<String>(rc.selfRoles);
        HashSet visitedBlueprintIds = Sets.newHashSet();
        for (String inheritBlueprintId : rc.inheritBlueprintIds) {
            if (visitedBlueprintIds.contains(inheritBlueprintId)) continue;
            visitedBlueprintIds.add(inheritBlueprintId);
            roles.addAll(this.assembleRolesWithInheritanceAtBlueprintLevel(context, inheritBlueprintId, visitedBlueprintIds));
        }
        return roles;
    }

    private Set<String> assembleRolesWithInheritanceAtArtifactExistingLevel(RolesComputationContext context, String artifactId) {
        return this.assembleRolesWithInheritanceAtArtifactExistingLevel(context, artifactId, Sets.newHashSet(), Sets.newHashSet((Object[])new String[]{artifactId}));
    }

    private Set<String> assembleRolesWithInheritanceAtArtifactExistingLevel(RolesComputationContext context, String artifactId, Set<String> visitedBlueprintIds, Set<String> visitedArtifactsIds) {
        RolesComputationContext.RolesComputationResult computationForArtifact = context.artifactExistingLevel.get(artifactId);
        HashSet<String> rolesWithInheritance = new HashSet<String>(computationForArtifact.selfRoles);
        for (String inheritBlueprintId : computationForArtifact.inheritBlueprintIds) {
            if (inheritBlueprintId == null || visitedBlueprintIds.contains(inheritBlueprintId)) continue;
            visitedBlueprintIds.add(inheritBlueprintId);
            rolesWithInheritance.addAll(this.assembleRolesWithInheritanceAtBlueprintLevel(context, inheritBlueprintId, visitedBlueprintIds));
        }
        for (String inheritArtifactId : computationForArtifact.inheritArtifactIds) {
            if (inheritArtifactId == null || visitedArtifactsIds.contains(inheritArtifactId)) continue;
            visitedArtifactsIds.add(inheritArtifactId);
            rolesWithInheritance.addAll(this.assembleRolesWithInheritanceAtArtifactExistingLevel(context, inheritArtifactId, visitedBlueprintIds, visitedArtifactsIds));
        }
        return rolesWithInheritance;
    }

    private Set<String> assembleRolesWithInheritanceAtArtifactDeletedLevel(RolesComputationContext context, String artifactId) {
        RolesComputationContext.RolesComputationResult rc = context.artifactDeletedLevel.get(artifactId);
        HashSet<String> roles = new HashSet<String>(rc.selfRoles);
        HashSet visitedBlueprintIds = Sets.newHashSet();
        for (String inheritBlueprintId : rc.inheritBlueprintIds) {
            if (visitedBlueprintIds.contains(inheritBlueprintId)) continue;
            visitedBlueprintIds.add(inheritBlueprintId);
            roles.addAll(this.assembleRolesWithInheritanceAtBlueprintLevel(context, inheritBlueprintId, visitedBlueprintIds));
        }
        return roles;
    }

    private Set<String> computeRolesFromRules(@Nullable BlueprintRoleAssignments blueprintRoleAssignments, @Nullable ArtifactRoleAssignments artifactRoleAssignments, BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate, AuthCtx authCtx, @Nullable EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        HashSet<String> rolesIds = new HashSet<String>();
        if (blueprintRoleAssignments != null) {
            this.computeRolesFromRules(rolesIds, blueprintRoleAssignments.roleAssignmentsRules, criterionPredicate, authCtx, enrichedArtifact, rolesAssignmentsAudit);
        }
        if (artifactRoleAssignments != null) {
            this.computeRolesFromRules(rolesIds, artifactRoleAssignments.roleAssignmentsRules, criterionPredicate, authCtx, enrichedArtifact, rolesAssignmentsAudit);
        }
        return rolesIds;
    }

    private void computeRolesFromRules(Set<String> rolesIds, Map<String, List<RoleAssignmentsRule>> roleAssignmentsRules, BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate, AuthCtx authCtx, @Nullable EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        for (Map.Entry<String, List<RoleAssignmentsRule>> entry : roleAssignmentsRules.entrySet()) {
            String roleId = entry.getKey();
            RolesAndPermissionsAudit.RoleAssignmentAudit roleAssignmentAudit = rolesAssignmentsAudit.addRoleAssignmentAudit(roleId);
            if (rolesAssignmentsAudit.auditConfiguration.shouldBreak(rolesIds.contains(roleId))) {
                roleAssignmentAudit.declareRoleAlreadyAssigned();
                continue;
            }
            boolean assignedRole = false;
            for (RoleAssignmentsRule rar : entry.getValue()) {
                RolesAndPermissionsAudit.RoleAssignmentRuleAudit roleAssignmentRuleAudit;
                if (this.isCurrentUserMatchedByBlueprintRoleAssignments(authCtx, rar, enrichedArtifact, roleAssignmentRuleAudit = roleAssignmentAudit.addRoleAssignmentRuleAudit())) {
                    roleAssignmentRuleAudit.declareUserMatched();
                    if (RoleAssignmentsComputationUtils.doRuleCriteriaComply(rar, criterionPredicate, roleAssignmentRuleAudit)) {
                        roleAssignmentRuleAudit.declareValid();
                        assignedRole = true;
                        if (!rolesAssignmentsAudit.auditConfiguration.shouldBreak()) continue;
                        break;
                    }
                    roleAssignmentRuleAudit.declareNotValid();
                    continue;
                }
                roleAssignmentRuleAudit.declareUserNotMatched();
            }
            if (assignedRole) {
                roleAssignmentAudit.declareRoleAssigned();
                rolesIds.add(roleId);
                continue;
            }
            roleAssignmentAudit.declareRoleNotAssigned();
        }
    }

    private boolean isCurrentUserMatchedByBlueprintRoleAssignments(AuthCtx authCtx, RoleAssignmentsRule roleAssignmentsRule, @Nullable EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RoleAssignmentRuleAudit roleAssignmentRuleAudit) throws IOException {
        boolean isCurrentUserMatched = false;
        for (UsersContainer usersContainer : roleAssignmentsRule.userContainers) {
            RolesAndPermissionsAudit.UserMatchAudit userMatchAudit;
            if (!this.isCurrentUserMatchedByUserContainer(usersContainer, authCtx, userMatchAudit = roleAssignmentRuleAudit.addUserMatchAudit())) continue;
            isCurrentUserMatched = true;
            if (!roleAssignmentRuleAudit.auditConfiguration.shouldBreak()) continue;
            return true;
        }
        if (enrichedArtifact != null) {
            for (String fieldId : roleAssignmentsRule.fieldIds) {
                if (!this.isCurrentUserMatchedByFieldId(fieldId, authCtx, enrichedArtifact, roleAssignmentRuleAudit)) continue;
                isCurrentUserMatched = true;
                if (!roleAssignmentRuleAudit.auditConfiguration.shouldBreak()) continue;
                return true;
            }
        }
        return isCurrentUserMatched;
    }

    private boolean isCurrentUserMatchedByUserContainer(UsersContainer usersContainer, AuthCtx authCtx, RolesAndPermissionsAudit.UserMatchAudit userMatchAudit) {
        boolean userMatched = false;
        if (usersContainer instanceof UserUsersContainer) {
            userMatchAudit.declareTypeUser(((UserUsersContainer)usersContainer).login);
            if (StringUtils.equals((CharSequence)authCtx.getAssociatedDSSUser(), (CharSequence)((UserUsersContainer)usersContainer).login)) {
                userMatched = true;
            }
        } else if (usersContainer instanceof GroupUsersContainer) {
            userMatchAudit.declareTypeGroup(((GroupUsersContainer)usersContainer).groupName);
            if (authCtx.isGroupsAware() && authCtx.isInGroup(((GroupUsersContainer)usersContainer).groupName)) {
                userMatched = true;
            }
        } else if (usersContainer instanceof GlobalAPIKeyUsersContainer) {
            String apiKeyValue = "api:" + ((GlobalAPIKeyUsersContainer)usersContainer).globalAPIKeyId;
            userMatchAudit.declareTypeGlobalAPIKey(apiKeyValue);
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL && StringUtils.equals((CharSequence)authCtx.getIdentifier(), (CharSequence)apiKeyValue)) {
                userMatched = true;
            }
        }
        if (userMatched) {
            userMatchAudit.declareMatched();
        } else {
            userMatchAudit.declareNotMatched();
        }
        return userMatched;
    }

    private boolean isCurrentUserMatchedByFieldId(String fieldId, final AuthCtx authCtx, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RoleAssignmentRuleAudit roleAssignmentRuleAudit) throws IOException {
        FieldDefinition fieldDefinition = enrichedArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
        final Object fieldValue = enrichedArtifact.artifact.fields.get(fieldId);
        final RolesAndPermissionsAudit.FieldUserMatchAudit fieldUserMatchAudit = roleAssignmentRuleAudit.addFieldUserMatchAudit(fieldId, fieldValue);
        if (fieldDefinition == null) {
            fieldUserMatchAudit.declareTypeNotExistingField();
            return false;
        }
        if (fieldValue == null) {
            fieldUserMatchAudit.declareNotMatched();
            return false;
        }
        try {
            class MatchingUserChecker
            extends HierarchicalFieldDefinitionVisitor {
                public boolean matchingUser;

                MatchingUserChecker() {
                }

                @Override
                public void visit(ReferenceFieldDefinition fieldDefinition, String fieldId) {
                    super.visit(fieldDefinition, fieldId);
                    new IFieldAndListValueVisitor(){

                        @Override
                        public void visit(String stringFieldValue) {
                            try {
                                if (UserBlueprintRoleAssignmentsComputationService.this.isCurrentUserRepresentedByArtifactId(authCtx, stringFieldValue, fieldUserMatchAudit)) {
                                    fieldUserMatchAudit.declareMatched();
                                    matchingUser = true;
                                } else {
                                    fieldUserMatchAudit.declareNotMatched();
                                }
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    }.visit(fieldValue);
                }
            }
            MatchingUserChecker checker = new MatchingUserChecker();
            fieldDefinition.accept(checker, fieldId);
            return checker.matchingUser;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private boolean isCurrentUserRepresentedByArtifactId(AuthCtx authCtx, String artifactId, RolesAndPermissionsAudit.FieldUserMatchAudit fieldUserMatchAudit) throws IOException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        if (StringUtils.equals((CharSequence)enrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.USER.blueprintId)) {
            fieldUserMatchAudit.declareTypeUser();
            return StringUtils.isNotBlank((CharSequence)enrichedArtifact.enrichedArtifactDetails.userLogin) && StringUtils.equals((CharSequence)authCtx.getAssociatedDSSUser(), (CharSequence)enrichedArtifact.enrichedArtifactDetails.userLogin);
        }
        if (StringUtils.equals((CharSequence)enrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.GROUP.blueprintId)) {
            fieldUserMatchAudit.declareTypeGroup();
            return StringUtils.isNotBlank((CharSequence)enrichedArtifact.enrichedArtifactDetails.groupName) && authCtx.isGroupsAware() && authCtx.isInGroup(enrichedArtifact.enrichedArtifactDetails.groupName);
        }
        if (StringUtils.equals((CharSequence)enrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.GLOBAL_API_KEY.blueprintId)) {
            fieldUserMatchAudit.declareTypeAPIKey();
            return StringUtils.isNotBlank((CharSequence)enrichedArtifact.enrichedArtifactDetails.globalAPIKeyId) && authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL && StringUtils.equals((CharSequence)authCtx.getIdentifier(), (CharSequence)("api:" + enrichedArtifact.enrichedArtifactDetails.globalAPIKeyId));
        }
        return false;
    }

    private static class RolesComputationContext {
        public Map<String, RolesComputationResult> bpLevel = new HashMap<String, RolesComputationResult>();
        public Map<BlueprintVersionId, RolesComputationResult> bpvLevel = new HashMap<BlueprintVersionId, RolesComputationResult>();
        public Map<String, RolesComputationResult> artifactExistingLevel = new HashMap<String, RolesComputationResult>();
        public Map<String, RolesComputationResult> artifactDeletedLevel = new HashMap<String, RolesComputationResult>();

        private RolesComputationContext() {
        }

        private static class RolesComputationResult {
            public Set<String> selfRoles;
            public List<String> inheritBlueprintIds = new ArrayList<String>();
            public List<String> inheritArtifactIds = new ArrayList<String>();

            private RolesComputationResult() {
            }

            public static RolesComputationResult build(Set<String> selfRoles) {
                RolesComputationResult rc = new RolesComputationResult();
                rc.selfRoles = selfRoles;
                return rc;
            }
        }
    }
}

