/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.system;

import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SystemProvidedConstants {
    public static final String BLUEPRINT_VERSION_SYSTEM_DEFAULT = "bv.system.default";
    public static final String BLUEPRINT_VERSION_SYSTEM_DEFAULT_NAME = "Dataiku Standard";
    public static final String BLUEPRINT_VERSION_SYSTEM_SMV_PREDICTION = "bv.system.prediction";
    public static final String BLUEPRINT_VERSION_SYSTEM_SMV_CLUSTERING = "bv.system.clustering";
    public static final String BLUEPRINT_VERSION_SYSTEM_SMV_FINE_TUNING = "bv.system.fine_tuning";
    public static final String BLUEPRINT_VERSION_SYSTEM_SMV_AGENT = "bv.system.agent";
    public static final String BLUEPRINT_VERSION_SYSTEM_SMV_AUGMENTED = "bv.system.augmented";
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint USER = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.user", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GROUP = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.group", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GLOBAL_API_KEY = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.global_api_key", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint DATAIKU_PROJECT = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.dataiku_project", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint DATAIKU_BUNDLE = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.dataiku_bundle", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint DATAIKU_DATASET = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.dataiku_dataset", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint DATAIKU_SAVED_MODEL = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.dataiku_saved_model", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint DATAIKU_RETRIEVABLE_KNOWLEDGE = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.dataiku_retrievable_knowledge", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint DATAIKU_SAVED_MODEL_VERSION = SystemProvidedEnrichedBlueprint.build("bp.system.dataiku_saved_model_version", true, Sets.newHashSet((Object[])new String[]{"bv.system.prediction", "bv.system.clustering", "bv.system.fine_tuning", "bv.system.agent", "bv.system.augmented"}));
    public static final Set<String> RESTRICTED_TO_ADVANCED_LICENSE_SAVED_MODEL_VERSIONS = Set.of("bv.system.fine_tuning", "bv.system.agent", "bv.system.augmented");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint BUSINESS_INITIATIVE = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.business_initiative", false, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GOVERN_PROJECT = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.govern_project", false, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GOVERN_BUNDLE = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.govern_bundle", false, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GOVERN_DATASET = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.govern_dataset", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GOVERN_MODEL = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.govern_model", false, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint GOVERN_MODEL_VERSION = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.govern_model_version", false, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint API_DEPLOYER_INFRA = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.api_deployer_infrastructure", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint PROJECT_DEPLOYER_INFRA = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.project_deployer_infrastructure", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint API_DEPLOYER_DEPLOYMENT = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.api_deployer_deployment", true, "bv.system.default");
    public static final SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint PROJECT_DEPLOYER_DEPLOYMENT = SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint.build("bp.system.project_deployer_deployment", true, "bv.system.default");
    public static final Map<String, SystemProvidedEnrichedBlueprint> DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID = Stream.of(DATAIKU_PROJECT, DATAIKU_BUNDLE, DATAIKU_DATASET, DATAIKU_SAVED_MODEL, DATAIKU_RETRIEVABLE_KNOWLEDGE, DATAIKU_SAVED_MODEL_VERSION).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final Map<String, SystemProvidedEnrichedBlueprint> GOVERN_SYSTEM_BLUEPRINT_BY_ID = Stream.of(GOVERN_PROJECT, GOVERN_BUNDLE, GOVERN_DATASET, GOVERN_MODEL, GOVERN_MODEL_VERSION).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final Map<String, SystemProvidedEnrichedBlueprint> DEPLOYER_ITEMS_SYSTEM_BLUEPRINT_BY_ID = Stream.of(API_DEPLOYER_INFRA, PROJECT_DEPLOYER_INFRA, API_DEPLOYER_DEPLOYMENT, PROJECT_DEPLOYER_DEPLOYMENT).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final Map<String, SystemProvidedEnrichedBlueprint> DEPLOYABLE_ITEMS_SYSTEM_BLUEPRINT_BY_ID = Stream.of(DATAIKU_BUNDLE, GOVERN_BUNDLE, DATAIKU_SAVED_MODEL_VERSION, GOVERN_MODEL_VERSION).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final Map<String, SystemProvidedEnrichedBlueprint> GOVERN_DEPLOYABLE_ITEMS_SYSTEM_BLUEPRINT_BY_ID = Stream.of(GOVERN_BUNDLE, GOVERN_MODEL_VERSION).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final Map<String, SystemProvidedEnrichedBlueprint> DATAIKU_DEPLOYABLE_ITEMS_SYSTEM_BLUEPRINT_BY_ID = Stream.of(DATAIKU_BUNDLE, DATAIKU_SAVED_MODEL_VERSION).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final Map<String, SystemProvidedEnrichedBlueprint> SYSTEM_BLUEPRINT_BY_ID = Stream.of(Stream.of(USER, GROUP, GLOBAL_API_KEY, BUSINESS_INITIATIVE), DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.values().stream(), GOVERN_SYSTEM_BLUEPRINT_BY_ID.values().stream(), DEPLOYER_ITEMS_SYSTEM_BLUEPRINT_BY_ID.values().stream()).flatMap(Function.identity()).collect(Collectors.toMap(obj -> obj.blueprintId, obj -> obj));
    public static final String SUB_JSON_VALUE_KEY = "value";
    public static final String USER_GROUPS_FIELD_ID = "groups";
    public static final String DATAIKU_SAVED_MODEL_TYPE_FIELD_ID = "model_type";
    public static final String LLM_MODEL_TYPE_FIELD_VALUE = "LLM_GENERIC_RAW";

    public static boolean isArtifactsSystemLockEnabledForBlueprint(String blueprintId) {
        SystemProvidedEnrichedBlueprint systemProvidedEnrichedBlueprint = SYSTEM_BLUEPRINT_BY_ID.get(blueprintId);
        return systemProvidedEnrichedBlueprint != null && systemProvidedEnrichedBlueprint.systemLocked;
    }

    public static boolean isGovernBlueprint(String blueprintId) {
        return GOVERN_SYSTEM_BLUEPRINT_BY_ID.containsKey(blueprintId);
    }

    public static boolean isGovernDeployableBlueprint(String blueprintId) {
        return GOVERN_DEPLOYABLE_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(blueprintId);
    }

    public static boolean isDataikuDeployableBlueprint(String blueprintId) {
        return DATAIKU_DEPLOYABLE_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(blueprintId);
    }

    public static boolean isDataikuProjectItemBlueprint(String blueprintId) {
        return DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(blueprintId);
    }

    public static boolean isDeployableBlueprint(String blueprintID) {
        return DEPLOYABLE_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(blueprintID);
    }
}

