/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.search.ArtifactPostFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchPagination;
import com.dataiku.gh.core.models.search.ArtifactSearchQuery;
import com.dataiku.gh.core.models.search.ArtifactSearchSort;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.services.validation.validators.ArtifactFilterValidator;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.IArtifactSearchQueryVisitor;
import org.apache.commons.lang.StringUtils;

public class ArtifactSearchQueryValidator
extends ArtifactFilterValidator
implements IArtifactSearchQueryVisitor {
    @Override
    public void visit(ArtifactSearchPagination artifactSearchPagination) {
    }

    @Override
    public void visit(ArtifactSearchQuery artifactSearchQuery) {
    }

    @Override
    public void visit(ArtifactSearchSort artifactSearchSort) {
    }

    @Override
    public void visit(ArtifactSearchSort.FieldSortColumnField fieldSortColumnField) {
        if (fieldSortColumnField.blueprintId != null && !IdentifiersUtils.isValidBlueprintId(fieldSortColumnField.blueprintId)) {
            throw new ValidationException("Field 'blueprintId' is not valid on 'fieldSortColumnField'");
        }
        if (StringUtils.isBlank((String)fieldSortColumnField.fieldId)) {
            throw new ValidationException("Field 'fieldId' is required on 'fieldSortColumnField'");
        }
    }

    @Override
    public void visit(ArtifactSearchSort.SortColumn sortColumn) {
    }

    @Override
    public void visit(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource) {
    }

    @Override
    public void visit(ArtifactPostFilter.FieldsPermissionsArtifactPostFilter fieldsPermissionsArtifactPostFilter) {
        throw new ValidationException("FieldsPermissionsArtifactPostFilter is not currently supported");
    }

    @Override
    public void visit(ArtifactPostFilter.BackreferenceFillerArtifactPostFilter backreferenceFillerArtifactPostFilter) {
        ValidatorUtils.validateThat(backreferenceFillerArtifactPostFilter.backreferenceFieldDefinition != null, "backreferenceFieldDefinition is required", new Object[0]);
        backreferenceFillerArtifactPostFilter.backreferenceFieldDefinition.references.forEach(fieldReference -> {
            ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintId(fieldReference.blueprintId), "Invalid referenced blueprint ID: " + fieldReference.blueprintId, new Object[0]);
            ValidatorUtils.validateThat(fieldReference.fieldId != null, "fieldId is required", new Object[0]);
        });
        ValidatorUtils.validateThat(backreferenceFillerArtifactPostFilter.blueprintVersionId != null, "blueprintVersionId is required", new Object[0]);
        if (!IdentifiersUtils.isValidBlueprintVersionId(backreferenceFillerArtifactPostFilter.blueprintVersionId.versionId)) {
            throw new ValidationException("Invalid blueprint version ID: " + String.valueOf(backreferenceFillerArtifactPostFilter.blueprintVersionId));
        }
        if (!IdentifiersUtils.isValidBlueprintId(backreferenceFillerArtifactPostFilter.blueprintVersionId.blueprintId)) {
            throw new ValidationException("Invalid referenced blueprint ID: " + backreferenceFillerArtifactPostFilter.blueprintVersionId.blueprintId);
        }
    }
}

