/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.gh.core.storage.sql.QueryDslJdbcTemplate;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.SQLTemplates;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DatabaseConfiguration {
    @Autowired
    private PasswordEncryptionService cryptoService;

    @Bean
    public DataSource registerDataSource() {
        String jdbcUrl = DKUApp.getMandatoryProperty((String)"psql.jdbc.url");
        String jdbcUser = DKUApp.getProperty((String)"psql.jdbc.user", (String)"");
        String jdbcPassword = this.cryptoService.decryptIfEncrypted(DKUApp.getProperty((String)"psql.jdbc.password", (String)""));
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(jdbcUrl);
        if (StringUtils.isNotBlank((CharSequence)jdbcUser)) {
            ds.setUsername(jdbcUser);
            ds.setPassword(jdbcPassword);
        }
        DatabaseConfiguration.configureHikariDataSource(ds);
        return ds;
    }

    @Bean
    public PlatformTransactionManager getTransactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public com.querydsl.sql.Configuration querydslConfiguration() {
        SQLTemplates templates = PostgreSQLTemplates.builder().build();
        com.querydsl.sql.Configuration configuration = new com.querydsl.sql.Configuration(templates);
        return configuration;
    }

    @Bean
    public SQLQueryFactory queryFactory() {
        return new SQLQueryFactory(this.querydslConfiguration(), this.registerDataSource());
    }

    @Bean
    public QueryDslJdbcTemplate jdbcTemplate(DataSource dataSource) {
        return new QueryDslJdbcTemplate(dataSource);
    }

    public static void configureHikariDataSource(HikariDataSource ds) {
        ds.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        ds.setConnectionInitSql("SET SESSION TIME ZONE 'UTC';");
    }
}

