/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server;

import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.google.common.base.Joiner;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="CorsFilter")
public class CorsFilter
extends OncePerRequestFilter {
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String origin = request.getHeader("Origin");
        GeneralSettingsDAO.CorsSettings corsSettings = this.generalSettingsDAO.getUnsafeAutoTXN().corsSettings;
        if (this.doesOriginMatchCorsFilter(origin, corsSettings.accessControlAllowOriginRegExps)) {
            response.addHeader("Access-Control-Allow-Origin", origin);
            if (corsSettings.accessControlAllowHeaders.size() > 0) {
                response.addHeader("Access-Control-Allow-Headers", Joiner.on((String)", ").join(corsSettings.accessControlAllowHeaders));
            }
            if (corsSettings.accessControlAllowMethods.size() > 0) {
                response.addHeader("Access-Control-Allow-Methods", Joiner.on((String)", ").join(corsSettings.accessControlAllowMethods));
            }
            if (corsSettings.accessControlExposeHeaders.size() > 0) {
                response.addHeader("Access-Control-Expose-Headers", Joiner.on((String)", ").join(corsSettings.accessControlExposeHeaders));
            }
            if (corsSettings.accessControlMaxAge != null) {
                response.addHeader("Access-Control-Max-Age", String.valueOf(corsSettings.accessControlMaxAge));
            }
            if (corsSettings.accessControlAllowCredentials) {
                response.addHeader("Access-Control-Allow-Credentials", "true");
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean doesOriginMatchCorsFilter(String origin, Set<String> accessControlAllowOrigin) {
        if (origin == null) {
            return false;
        }
        if (accessControlAllowOrigin.contains("*")) {
            return true;
        }
        for (String corsOriginRegExp : accessControlAllowOrigin) {
            if (!origin.matches(corsOriginRegExp)) continue;
            return true;
        }
        return false;
    }
}

