/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;

public class StageInfo
implements Serializable {
    private static final String GCS_REGION_ME_CENTRAL_2 = "me-central2";
    private static final long serialVersionUID = 1L;
    private StageType stageType;
    private String location;
    private Map<?, ?> credentials;
    private String region;
    private String endPoint;
    private String storageAccount;
    private String presignedUrl;
    private boolean isClientSideEncrypted;
    private boolean useS3RegionalUrl;
    private boolean useRegionalUrl;
    private Properties proxyProperties;

    public static StageInfo createStageInfo(String locationType, String location, Map<?, ?> credentials, String region, String endPoint, String storageAccount, boolean isClientSideEncrypted) throws IllegalArgumentException {
        StageType stageType;
        switch (locationType) {
            case "AZURE": {
                stageType = StageType.AZURE;
                if (StageInfo.isSpecified(location) && StageInfo.isSpecified(endPoint) && StageInfo.isSpecified(storageAccount) && credentials != null) break;
                throw new IllegalArgumentException("Incomplete parameters specified for Azure stage");
            }
            case "S3": {
                stageType = StageType.S3;
                if (StageInfo.isSpecified(location) && StageInfo.isSpecified(region) && credentials != null) break;
                throw new IllegalArgumentException("Incomplete parameters specified for S3 stage");
            }
            case "GCS": {
                stageType = StageType.GCS;
                if (StageInfo.isSpecified(location) && credentials != null) break;
                throw new IllegalArgumentException("Incomplete parameters specified for GCS stage");
            }
            case "LOCAL_FS": {
                stageType = StageType.LOCAL_FS;
                if (StageInfo.isSpecified(location)) break;
                throw new IllegalArgumentException("Incomplete parameters specific for local stage");
            }
            default: {
                throw new IllegalArgumentException("Invalid stage type: " + locationType);
            }
        }
        return new StageInfo(stageType, location, credentials, region, endPoint, storageAccount, isClientSideEncrypted);
    }

    private StageInfo(StageType stageType, String location, Map<?, ?> credentials, String region, String endPoint, String storageAccount, boolean isClientSideEncrypted) {
        this.stageType = stageType;
        this.location = location;
        this.credentials = credentials;
        this.region = region;
        this.endPoint = endPoint;
        this.storageAccount = storageAccount;
        this.isClientSideEncrypted = isClientSideEncrypted;
    }

    public StageType getStageType() {
        return this.stageType;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<?, ?> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<?, ?> credentials) {
        this.credentials = credentials;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getStorageAccount() {
        return this.storageAccount;
    }

    public String getPresignedUrl() {
        return this.presignedUrl;
    }

    public void setPresignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    public boolean getIsClientSideEncrypted() {
        return this.isClientSideEncrypted;
    }

    public void setUseS3RegionalUrl(boolean useS3RegionalUrl) {
        this.useS3RegionalUrl = useS3RegionalUrl;
    }

    public boolean getUseS3RegionalUrl() {
        return this.useS3RegionalUrl;
    }

    @SnowflakeJdbcInternalApi
    public void setUseRegionalUrl(boolean useRegionalUrl) {
        this.useRegionalUrl = useRegionalUrl;
    }

    @SnowflakeJdbcInternalApi
    public boolean getUseRegionalUrl() {
        return this.useRegionalUrl;
    }

    private static boolean isSpecified(String arg) {
        return arg != null && !arg.equalsIgnoreCase("");
    }

    public void setProxyProperties(Properties proxyProperties) {
        this.proxyProperties = proxyProperties;
    }

    public Properties getProxyProperties() {
        return this.proxyProperties;
    }

    @SnowflakeJdbcInternalApi
    public Optional<String> gcsCustomEndpoint() {
        if (this.stageType != StageType.GCS) {
            return Optional.empty();
        }
        if (this.endPoint != null && !this.endPoint.trim().isEmpty() && !"null".equals(this.endPoint)) {
            return Optional.of(this.endPoint);
        }
        if (GCS_REGION_ME_CENTRAL_2.equalsIgnoreCase(this.region) || this.useRegionalUrl) {
            return Optional.of(String.format("storage.%s.rep.googleapis.com", this.region.toLowerCase()));
        }
        return Optional.empty();
    }

    public static enum StageType {
        S3,
        AZURE,
        LOCAL_FS,
        GCS;

    }
}

