/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.tracing;

import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.longrunning.OperationSnapshot;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracerFactory;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.SpanName;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.TracedUnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;

public class TracedOperationInitialCallable<RequestT>
extends TracedUnaryCallable<RequestT, OperationSnapshot> {
    public TracedOperationInitialCallable(UnaryCallable<RequestT, OperationSnapshot> innerCallable, ApiTracerFactory tracedFactory, SpanName spanName) {
        super(innerCallable, tracedFactory, spanName);
    }

    @Override
    public ApiFuture<OperationSnapshot> futureCall(RequestT request, ApiCallContext context) {
        InitialCallableFinisher finisher = new InitialCallableFinisher(context.getTracer());
        try {
            ApiFuture<OperationSnapshot> future = super.futureCall(request, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }

    private static class InitialCallableFinisher
    implements ApiFutureCallback<OperationSnapshot> {
        private final ApiTracer operationTracer;

        private InitialCallableFinisher(ApiTracer operationTracer) {
            this.operationTracer = operationTracer;
        }

        @Override
        public void onSuccess(OperationSnapshot result) {
            this.operationTracer.lroStartSucceeded();
        }

        @Override
        public void onFailure(Throwable t2) {
            this.operationTracer.lroStartFailed(t2);
        }
    }
}

