/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.rls;

import java.util.HashMap;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.HashMultiset;
import net.snowflake.client.jdbc.internal.google.common.collect.Multiset;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.rls.SubchannelStateManager;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class SubchannelStateManagerImpl
implements SubchannelStateManager {
    private final HashMap<String, ConnectivityState> stateMap = new HashMap();
    private final Multiset<ConnectivityState> stateMultiset = HashMultiset.create();
    private ConnectivityState currentState;

    SubchannelStateManagerImpl() {
    }

    @Override
    public void updateState(String name, ConnectivityState newState) {
        ConnectivityState existing;
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(newState, "newState");
        if (newState == ConnectivityState.SHUTDOWN) {
            existing = this.stateMap.remove(name);
        } else {
            existing = this.stateMap.put(name, newState);
            this.stateMultiset.add(newState);
        }
        if (existing != null) {
            this.stateMultiset.remove((Object)existing);
        }
    }

    @Override
    @Nullable
    public ConnectivityState getState(String name) {
        return this.stateMap.get(Preconditions.checkNotNull(name, "name"));
    }

    @Override
    public ConnectivityState getAggregatedState() {
        if (this.stateMultiset.contains((Object)ConnectivityState.READY)) {
            this.currentState = ConnectivityState.READY;
        } else if (this.stateMultiset.contains((Object)ConnectivityState.CONNECTING)) {
            if (this.currentState != ConnectivityState.TRANSIENT_FAILURE) {
                this.currentState = ConnectivityState.CONNECTING;
            }
        } else {
            this.currentState = this.stateMultiset.contains((Object)ConnectivityState.IDLE) ? ConnectivityState.IDLE : (this.stateMultiset.contains((Object)ConnectivityState.TRANSIENT_FAILURE) ? ConnectivityState.TRANSIENT_FAILURE : ConnectivityState.IDLE);
        }
        return this.currentState;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("stateMap", this.stateMap).toString();
    }
}

