/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.trace;

import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.ImmutableSpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.OtelEncodingUtils;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanId;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceFlags;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceId;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceState;

@Immutable
public interface SpanContext {
    public static SpanContext getInvalid() {
        return ImmutableSpanContext.INVALID;
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, false, false);
    }

    public static SpanContext createFromRemoteParent(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, true, false);
    }

    public String getTraceId();

    default public byte[] getTraceIdBytes() {
        return OtelEncodingUtils.bytesFromBase16(this.getTraceId(), TraceId.getLength());
    }

    public String getSpanId();

    default public byte[] getSpanIdBytes() {
        return OtelEncodingUtils.bytesFromBase16(this.getSpanId(), SpanId.getLength());
    }

    default public boolean isSampled() {
        return this.getTraceFlags().isSampled();
    }

    public TraceFlags getTraceFlags();

    public TraceState getTraceState();

    default public boolean isValid() {
        return TraceId.isValid(this.getTraceId()) && SpanId.isValid(this.getSpanId());
    }

    public boolean isRemote();
}

