/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.GlobUtil;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.Aggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentSelector;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.View;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.AdviceAttributesProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.NoopAttributesProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.RegisteredView;

@Immutable
public final class ViewRegistry {
    static final View DEFAULT_VIEW = View.builder().build();
    static final RegisteredView DEFAULT_REGISTERED_VIEW = RegisteredView.create(InstrumentSelector.builder().setName("*").build(), DEFAULT_VIEW, NoopAttributesProcessor.NOOP, 2000, SourceInfo.noSourceInfo());
    private static final Logger logger = Logger.getLogger(ViewRegistry.class.getName());
    private final Map<InstrumentType, RegisteredView> instrumentDefaultRegisteredView = new HashMap<InstrumentType, RegisteredView>();
    private final List<RegisteredView> registeredViews;

    ViewRegistry(DefaultAggregationSelector defaultAggregationSelector, CardinalityLimitSelector cardinalityLimitSelector, List<RegisteredView> registeredViews) {
        for (InstrumentType instrumentType : InstrumentType.values()) {
            this.instrumentDefaultRegisteredView.put(instrumentType, RegisteredView.create(InstrumentSelector.builder().setName("*").build(), View.builder().setAggregation(defaultAggregationSelector.getDefaultAggregation(instrumentType)).build(), AttributesProcessor.noop(), cardinalityLimitSelector.getCardinalityLimit(instrumentType), SourceInfo.noSourceInfo()));
        }
        this.registeredViews = registeredViews;
    }

    public static ViewRegistry create(DefaultAggregationSelector defaultAggregationSelector, CardinalityLimitSelector cardinalityLimitSelector, List<RegisteredView> registeredViews) {
        return new ViewRegistry(defaultAggregationSelector, cardinalityLimitSelector, new ArrayList<RegisteredView>(registeredViews));
    }

    public static ViewRegistry create() {
        return ViewRegistry.create(unused -> Aggregation.defaultAggregation(), CardinalityLimitSelector.defaultCardinalityLimitSelector(), Collections.emptyList());
    }

    public List<RegisteredView> findViews(InstrumentDescriptor descriptor, InstrumentationScopeInfo meterScope) {
        ArrayList<RegisteredView> result = new ArrayList<RegisteredView>();
        for (RegisteredView entry : this.registeredViews) {
            if (!ViewRegistry.matchesSelector(entry.getInstrumentSelector(), descriptor, meterScope)) continue;
            AggregatorFactory viewAggregatorFactory = (AggregatorFactory)((Object)entry.getView().getAggregation());
            if (viewAggregatorFactory.isCompatibleWithInstrument(descriptor)) {
                result.add(entry);
                continue;
            }
            logger.log(Level.WARNING, "View aggregation " + AggregationUtil.aggregationName(entry.getView().getAggregation()) + " is incompatible with instrument " + descriptor.getName() + " of type " + (Object)((Object)descriptor.getType()));
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        RegisteredView instrumentDefaultView = Objects.requireNonNull(this.instrumentDefaultRegisteredView.get((Object)descriptor.getType()));
        AggregatorFactory viewAggregatorFactory = (AggregatorFactory)((Object)instrumentDefaultView.getView().getAggregation());
        if (!viewAggregatorFactory.isCompatibleWithInstrument(descriptor)) {
            logger.log(Level.WARNING, "Instrument default aggregation " + AggregationUtil.aggregationName(instrumentDefaultView.getView().getAggregation()) + " is incompatible with instrument " + descriptor.getName() + " of type " + (Object)((Object)descriptor.getType()));
            instrumentDefaultView = DEFAULT_REGISTERED_VIEW;
        }
        if (descriptor.getAdvice().hasAttributes()) {
            instrumentDefaultView = ViewRegistry.applyAdviceToDefaultView(instrumentDefaultView, descriptor.getAdvice());
        }
        return Collections.singletonList(instrumentDefaultView);
    }

    private static boolean matchesSelector(InstrumentSelector selector, InstrumentDescriptor descriptor, InstrumentationScopeInfo meterScope) {
        if (selector.getInstrumentType() != null && selector.getInstrumentType() != descriptor.getType()) {
            return false;
        }
        if (selector.getInstrumentUnit() != null && !selector.getInstrumentUnit().equals(descriptor.getUnit())) {
            return false;
        }
        if (selector.getInstrumentName() != null && !GlobUtil.toGlobPatternPredicate(selector.getInstrumentName()).test(descriptor.getName())) {
            return false;
        }
        return ViewRegistry.matchesMeter(selector, meterScope);
    }

    private static boolean matchesMeter(InstrumentSelector selector, InstrumentationScopeInfo meterScope) {
        if (selector.getMeterName() != null && !selector.getMeterName().equals(meterScope.getName())) {
            return false;
        }
        if (selector.getMeterVersion() != null && !selector.getMeterVersion().equals(meterScope.getVersion())) {
            return false;
        }
        return selector.getMeterSchemaUrl() == null || selector.getMeterSchemaUrl().equals(meterScope.getSchemaUrl());
    }

    private static RegisteredView applyAdviceToDefaultView(RegisteredView instrumentDefaultView, Advice advice) {
        return RegisteredView.create(instrumentDefaultView.getInstrumentSelector(), instrumentDefaultView.getView(), new AdviceAttributesProcessor(Objects.requireNonNull(advice.getAttributes())), instrumentDefaultView.getCardinalityLimit(), instrumentDefaultView.getViewSourceInfo());
    }
}

