/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ocsp;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Object;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERTaggedObject;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ocsp.CertID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Extensions;

public class Request
extends ASN1Object {
    CertID reqCert;
    Extensions singleRequestExtensions;

    public Request(CertID certID, Extensions extensions) {
        this.reqCert = certID;
        this.singleRequestExtensions = extensions;
    }

    private Request(ASN1Sequence aSN1Sequence) {
        this.reqCert = CertID.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() == 2) {
            this.singleRequestExtensions = Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public static Request getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Request.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Request getInstance(Object object) {
        if (object instanceof Request) {
            return (Request)object;
        }
        if (object != null) {
            return new Request(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertID getReqCert() {
        return this.reqCert;
    }

    public Extensions getSingleRequestExtensions() {
        return this.singleRequestExtensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.reqCert);
        if (this.singleRequestExtensions != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.singleRequestExtensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

