/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.kernels;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedRKernel;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.auth.LambdaIntercomApiSecretAuthService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractLambdaRKernel
extends AbstractImpersonableSecretProtectedRKernel<ResponderKernelLink> {
    private final File codeEnvFolder;
    private final List<String> userCodePaths;
    private final ServiceGenContext ctx;
    private static final Logger logger = Logger.getLogger((String)"dku.apinode.kernels.r");

    protected AbstractLambdaRKernel(ResponderKernelLink link, ServiceGenContext ctx, List<String> userCodePaths, File codeEnvFolder, File kernelWorkDir, boolean impersonate, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType) {
        super((SecretProtectedKernelLink)link, cGrouppableProcessType, ((APITicketService)SpringUtils.getBean(APITicketService.class)).createTicket((AuthCtx)DSSAuthCtx.newNone(), null, null), false, kernelWorkDir, impersonate, null, (AuthCtx)DSSAuthCtx.newNone(), null);
        this.ctx = ctx;
        this.codeEnvFolder = codeEnvFolder;
        this.userCodePaths = userCodePaths;
        this.kernelEnvVariables.put("LAMBDA_INTERCOM_API_SECRET", ((LambdaIntercomApiSecretAuthService)SpringUtils.getBean(LambdaIntercomApiSecretAuthService.class)).getInternalApiSecret());
    }

    protected List<String> getRCmd() {
        ArrayList<String> cmd = new ArrayList<String>();
        logger.info((Object)("Starting R kernel codeEnvFolder=" + String.valueOf(this.codeEnvFolder)));
        if (this.codeEnvFolder != null && this.codeEnvFolder.isDirectory() && new File(this.codeEnvFolder, "env/bin/R").isFile()) {
            cmd.add(new File(this.codeEnvFolder, "env/bin/R").getAbsolutePath());
        } else {
            String rBin = System.getenv("DKURBIN");
            if (rBin == null) {
                throw new Error("environment variable DKURBIN not defined");
            }
            cmd.add(new File(rBin).getAbsolutePath());
        }
        return cmd;
    }

    protected IsolableProcess createAndStartProcess(ProcessBuilder pb) throws DKUSecurityException, IOException, InterruptedException {
        this.setRPath(pb, this.userCodePaths);
        pb.environment().put("DKU_CURRENT_APISERVICE", this.ctx.getServiceId());
        pb.environment().put("DKU_CURRENT_APISERVICE_GENERATION", this.ctx.getGenerationId());
        return super.createAndStartProcess(pb);
    }

    private void setRPath(ProcessBuilder pb, List<String> paths) {
        String rPath = System.getenv("DKU_SOURCE_LIB_R_PATH");
        if (rPath == null) {
            rPath = "";
        }
        StringBuilder rPathBuilder = new StringBuilder(rPath);
        for (String path : paths) {
            if (StringUtils.isBlank((String)path)) continue;
            rPathBuilder.append(":").append(path);
        }
        rPath = rPathBuilder.toString();
        while (rPath.startsWith(":")) {
            rPath = rPath.substring(1);
        }
        if (!StringUtils.isBlank((String)rPath)) {
            pb.environment().put("DKU_SOURCE_LIB_R_PATH", rPath);
        }
    }
}

