/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.auth.ApiKeyAuthMethod;
import com.dataiku.lambda.model.serverconfig.AdminAPIKey;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiNodeAuthVerificationService {
    public static final String AUDIT_LOG_REF_UNAUTHORIZED_ADMIN_CALL = "unauthorizedAdminCall";
    private final LambdaContext lambdaContext;
    private final AdminAPIKey inMemoryKey;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.apinode.auth.service");

    @Autowired
    public ApiNodeAuthVerificationService(LambdaContext lambdaContext) {
        this.lambdaContext = lambdaContext;
        this.inMemoryKey = this.createInMemoryApiKeyForCLI();
    }

    public void checkAdmin(HttpServletRequest req) throws IOException, DKUSecurityException {
        try {
            ArrayList<AdminAPIKey> apiKeys = new ArrayList<AdminAPIKey>(this.lambdaContext.getAuthConfig().keys);
            new ApiKeyAuthMethod(this.apiKeyValidationFunction(apiKeys)).validate(req);
            AuditContextBase.addCustom((String)AUDIT_LOG_REF_UNAUTHORIZED_ADMIN_CALL, (String)"false");
        }
        catch (NotAuthenticatedException | UnauthorizedException e) {
            AuditContextBase.addCustom((String)AUDIT_LOG_REF_UNAUTHORIZED_ADMIN_CALL, (String)"true");
            throw e;
        }
    }

    private Function<String, Optional<AdminAPIKey>> apiKeyValidationFunction(List<AdminAPIKey> apiKeys) {
        return reqApiKey -> {
            if (reqApiKey.startsWith("dkuaps-im-")) {
                if (this.inMemoryKey.key.equals(reqApiKey)) {
                    return Optional.of(this.inMemoryKey);
                }
                return Optional.empty();
            }
            return apiKeys.stream().filter(AdminAPIKey::isValidKey).filter(key -> ApiKeyUtils.compareKeySecret((String)reqApiKey, (String)key.key)).findAny();
        };
    }

    public AdminAPIKey getInMemoryAPIKey() {
        return this.inMemoryKey;
    }

    private AdminAPIKey createInMemoryApiKeyForCLI() {
        AdminAPIKey newKey = new AdminAPIKey();
        newKey.id = ApiKeyUtils.generateInMemoryApiKeyId();
        newKey.key = ApiKeyUtils.generateInMemoryApiKeySecret();
        newKey.createdOn = new Date().getTime();
        newKey.createdBy = "cli-apinode-admin";
        newKey.label = "Key generated for CLI API client";
        return newKey;
    }

    public void verifyDebugAccess(HttpServletRequest req) throws DKUSecurityException {
        String receivedSecret = req.getHeader("X-DKU-IPythonSharedSecret");
        String expectedSecret = SharedSecretUtils.getSharedSecret((boolean)false);
        if (receivedSecret != null && StringUtils.equals((String)receivedSecret.trim(), (String)expectedSecret)) {
            logger.debug((Object)"Debug call allowed via shared secret");
            return;
        }
        throw new DKUSecurityException("You are not allowed to call this");
    }
}

