/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.services;

import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LambdaOpenAPIService {
    @Autowired
    private ServicesService servicesService;
    @Autowired
    private LambdaContext lambdaContext;

    @Nullable
    public File getOpenAPIDocFileOrNull_Check(String serviceId) throws IOException {
        File openAPIDocFile;
        ServiceManager sm = this.servicesService.getServiceManager(serviceId);
        String id = sm.getServiceId();
        if (!sm.isActive()) {
            throw new IllegalArgumentException("No generation is active on service " + id);
        }
        GenerationsMapping mapping = sm.getCurrentGenerationsMapping();
        String openAPIGeneration = mapping.openAPIGeneration;
        if (StringUtils.isBlank((String)openAPIGeneration)) {
            openAPIGeneration = ((GenerationsMapping.MappingEntry)mapping.getEntries().get((int)0)).generation;
        }
        if ((openAPIDocFile = this.lambdaContext.getFile(new String[]{"services", id, "gens", openAPIGeneration, "swagger.json"})) == null || !openAPIDocFile.exists()) {
            return null;
        }
        return openAPIDocFile;
    }
}

