/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class ParquetSchemaUtils {
    public static final int DECIMAL_MAX_DIGITS_IN_INT = 9;
    public static final int DECIMAL_MAX_DIGITS_IN_LONG = 18;
    public static final List<Integer> MAX_BYTES_PER_PRECISION;

    private ParquetSchemaUtils() {
    }

    static MessageType pruneSchema(GroupType groupType, StructType structType) {
        return new MessageType("fileSchema", ParquetSchemaUtils.pruneFields(groupType, structType));
    }

    static Type findSubFieldType(GroupType groupType, StructField structField, Map<Integer, Type> map) {
        String string;
        Optional<Integer> optional = ParquetSchemaUtils.getFieldId(structField.getMetadata());
        if (optional.isPresent() && (string = map.get(optional.get())) != null) {
            return string;
        }
        string = structField.getName();
        if (groupType.containsField(string)) {
            return groupType.getType(string);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }

    static Map<Integer, Type> getParquetFieldToTypeMap(GroupType groupType) {
        return groupType.getFields().stream().filter(type -> type.getId() != null).collect(Collectors.toMap(type -> type.getId().intValue(), type -> type, (type, type2) -> {
            throw new IllegalStateException(String.format("Parquet file contains multiple columns (%s, %s) with the same field id", type, type2));
        }));
    }

    static MessageType toParquetSchema(StructType structType) {
        BiFunction<Optional<Integer>, Boolean, Optional<Integer>> biFunction = ParquetSchemaUtils.createFieldIdValidator(structType);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (StructField structField : structType.fields()) {
            Optional<Integer> optional = biFunction.apply(ParquetSchemaUtils.getFieldId(structField.getMetadata()), false);
            arrayList.add(ParquetSchemaUtils.toParquetType(structField, structField.getName(), structField.getDataType(), structField.getName(), structField.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, optional, biFunction));
        }
        return new MessageType("DefaultKernelSchema", arrayList);
    }

    private static List<Type> pruneFields(GroupType groupType, StructType structType) {
        Map<Integer, Type> map = ParquetSchemaUtils.getParquetFieldToTypeMap(groupType);
        return structType.fields().stream().map(structField -> {
            Type type = ParquetSchemaUtils.findSubFieldType(groupType, structField, map);
            if (type != null) {
                return ParquetSchemaUtils.prunedType(type, structField.getDataType());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Type prunedType(Type type, DataType dataType) {
        if (type instanceof GroupType && dataType instanceof StructType) {
            GroupType groupType = (GroupType)type;
            StructType structType = (StructType)dataType;
            return groupType.withNewFields(ParquetSchemaUtils.pruneFields(groupType, structType));
        }
        return type;
    }

    private static Type toParquetType(StructField structField, String string, DataType dataType, String string2, Type.Repetition repetition, Optional<Integer> optional, BiFunction<Optional<Integer>, Boolean, Optional<Integer>> biFunction) {
        Type type;
        if (dataType instanceof BooleanType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(string2);
        } else if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(string2);
        } else if (dataType instanceof LongType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(string2);
        } else if (dataType instanceof FloatType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(string2);
        } else if (dataType instanceof DoubleType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(string2);
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            int n = decimalType.getPrecision();
            int n2 = decimalType.getScale();
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = LogicalTypeAnnotation.decimalType((int)n2, (int)n);
            type = n <= 9 ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalLogicalTypeAnnotation)).named(string2) : (n <= 18 ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalLogicalTypeAnnotation)).named(string2) : (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalLogicalTypeAnnotation)).length(MAX_BYTES_PER_PRECISION.get(n).intValue())).named(string2));
        } else if (dataType instanceof StringType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(string2);
        } else if (dataType instanceof BinaryType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(string2);
        } else if (dataType instanceof DateType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(string2);
        } else if (dataType instanceof TimestampType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(string2);
        } else if (dataType instanceof TimestampNTZType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(string2);
        } else if (dataType instanceof ArrayType) {
            type = ParquetSchemaUtils.toParquetArrayType(structField, string, (ArrayType)dataType, string2, repetition, biFunction);
        } else if (dataType instanceof MapType) {
            type = ParquetSchemaUtils.toParquetMapType(structField, string, (MapType)dataType, string2, repetition, biFunction);
        } else if (dataType instanceof StructType) {
            type = ParquetSchemaUtils.toParquetStructType((StructType)dataType, string2, repetition, biFunction);
        } else {
            throw new UnsupportedOperationException("Writing given type data to Parquet is not supported: " + dataType);
        }
        if (optional.isPresent()) {
            type = type.withId(optional.get().intValue());
        }
        return type;
    }

    private static Type toParquetArrayType(StructField structField, String string, ArrayType arrayType, String string2, Type.Repetition repetition, BiFunction<Optional<Integer>, Boolean, Optional<Integer>> biFunction) {
        String string3 = string + ".element";
        Optional<Integer> optional = biFunction.apply(ParquetSchemaUtils.getNestedFieldId(structField, string3), true);
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)((Types.GroupBuilder)Types.repeatedGroup().addField(ParquetSchemaUtils.toParquetType(structField, string3, arrayType.getElementType(), "element", arrayType.containsNull() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, optional, biFunction))).named("list"))).named(string2);
    }

    private static Type toParquetMapType(StructField structField, String string, MapType mapType, String string2, Type.Repetition repetition, BiFunction<Optional<Integer>, Boolean, Optional<Integer>> biFunction) {
        String string3 = string + ".key";
        String string4 = string + ".value";
        Optional<Integer> optional = biFunction.apply(ParquetSchemaUtils.getNestedFieldId(structField, string3), true);
        Optional<Integer> optional2 = biFunction.apply(ParquetSchemaUtils.getNestedFieldId(structField, string4), true);
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.repeatedGroup().addField(ParquetSchemaUtils.toParquetType(structField, string3, mapType.getKeyType(), "key", Type.Repetition.REQUIRED, optional, biFunction))).addField(ParquetSchemaUtils.toParquetType(structField, string4, mapType.getValueType(), "value", mapType.isValueContainsNull() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, optional2, biFunction))).named("key_value"))).named(string2);
    }

    private static Type toParquetStructType(StructType structType, String string, Type.Repetition repetition, BiFunction<Optional<Integer>, Boolean, Optional<Integer>> biFunction) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (StructField structField : structType.fields()) {
            Optional<Integer> optional = biFunction.apply(ParquetSchemaUtils.getFieldId(structField.getMetadata()), false);
            arrayList.add(ParquetSchemaUtils.toParquetType(structField, structField.getName(), structField.getDataType(), structField.getName(), structField.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, optional, biFunction));
        }
        return new GroupType(repetition, string, arrayList);
    }

    private static Optional<Integer> getFieldId(FieldMetadata fieldMetadata) {
        return ParquetSchemaUtils.getFieldId(fieldMetadata, "parquet.field.id");
    }

    private static Optional<Integer> getNestedFieldId(StructField structField, String string) {
        FieldMetadata fieldMetadata = structField.getMetadata().getMetadata("parquet.field.nested.ids");
        if (fieldMetadata != null) {
            return ParquetSchemaUtils.getFieldId(fieldMetadata, string);
        }
        return Optional.empty();
    }

    private static Optional<Integer> getFieldId(FieldMetadata fieldMetadata, String string) {
        return Optional.ofNullable(fieldMetadata.getLong(string)).map(Math::toIntExact);
    }

    private static BiFunction<Optional<Integer>, Boolean, Optional<Integer>> createFieldIdValidator(StructType structType) {
        HashSet hashSet = new HashSet();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        AtomicBoolean atomicBoolean2 = new AtomicBoolean();
        AtomicBoolean atomicBoolean3 = new AtomicBoolean();
        AtomicBoolean atomicBoolean4 = new AtomicBoolean();
        return (optional, bl) -> {
            if (optional.isPresent()) {
                Preconditions.checkArgument(((Integer)optional.get() >= 0 ? 1 : 0) != 0, (String)"Field id should be non-negative.\n%s", (Object[])new Object[]{structType});
                Preconditions.checkArgument((boolean)hashSet.add(optional.get()), (String)"Field id should be unique.\n%s", (Object[])new Object[]{structType});
                if (bl.booleanValue()) {
                    atomicBoolean3.set(true);
                    Preconditions.checkArgument((!atomicBoolean4.get() && !atomicBoolean.get() ? 1 : 0) != 0, (String)"Some of the fields are missing field ids.\n%s", (Object[])new Object[]{structType});
                } else {
                    atomicBoolean2.set(true);
                    Preconditions.checkArgument((!atomicBoolean.get() ? 1 : 0) != 0, (String)"Some of the fields are missing field ids.\n%s", (Object[])new Object[]{structType});
                }
            } else if (bl.booleanValue()) {
                atomicBoolean4.set(true);
                Preconditions.checkArgument((!atomicBoolean3.get() && !atomicBoolean2.get() ? 1 : 0) != 0, (String)"Some of the fields are missing field ids.\n%s", (Object[])new Object[]{structType});
            } else {
                atomicBoolean.set(true);
                Preconditions.checkArgument((!atomicBoolean2.get() ? 1 : 0) != 0, (String)"Some of the fields are missing field ids.\n%s", (Object[])new Object[]{structType});
            }
            return optional;
        };
    }

    static {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i <= 38; ++i) {
            int n = 1;
            while (Math.pow(2.0, 8 * n - 1) < Math.pow(10.0, i)) {
                ++n;
            }
            arrayList.add(n);
        }
        MAX_BYTES_PER_PRECISION = Collections.unmodifiableList(arrayList);
    }
}

