/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.internal.util.Preconditions;
import java.util.Arrays;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;

abstract class RepeatedValueConverter
extends GroupConverter
implements ParquetColumnReaders.BaseColumnReader {
    private final Collector collector;
    private int currentRowIndex;
    private boolean[] nullability;
    private int[] offsets;
    private boolean isCurrentValueNull = true;

    RepeatedValueConverter(int n, Converter ... converterArray) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"invalid initialBatchSize: %s", (Object[])new Object[]{n});
        this.collector = new Collector(converterArray);
        this.nullability = ParquetColumnReaders.initNullabilityVector(n);
        this.offsets = new int[n + 1];
    }

    public Converter getConverter(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Invalid field index: " + n);
        }
        return this.collector;
    }

    public void start() {
        this.isCurrentValueNull = false;
    }

    public void end() {
    }

    @Override
    public void finalizeCurrentRow(long l) {
        this.resizeIfNeeded();
        this.offsets[this.currentRowIndex + 1] = this.collector.currentEntryIndex;
        this.nullability[this.currentRowIndex] = this.isCurrentValueNull;
        this.isCurrentValueNull = true;
        ++this.currentRowIndex;
    }

    @Override
    public void resizeIfNeeded() {
        if (this.nullability.length == this.currentRowIndex) {
            int n = this.nullability.length * 2;
            this.nullability = Arrays.copyOf(this.nullability, n);
            ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            this.offsets = Arrays.copyOf(this.offsets, n + 1);
        }
    }

    @Override
    public void resetWorkingState() {
        this.currentRowIndex = 0;
        this.isCurrentValueNull = true;
        this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
        this.offsets = new int[this.offsets.length];
    }

    protected boolean[] getNullability() {
        return this.nullability;
    }

    protected int[] getOffsets() {
        return this.offsets;
    }

    protected ColumnVector[] getElementDataVectors() {
        return this.collector.getDataVectors();
    }

    private static class Collector
    extends GroupConverter {
        private final Converter[] elementConverters;
        private int currentEntryIndex;

        Collector(Converter ... converterArray) {
            this.elementConverters = converterArray;
        }

        public Converter getConverter(int n) {
            if (n < 0 || n >= this.elementConverters.length) {
                throw new IllegalArgumentException("Invalid field index: " + n);
            }
            return this.elementConverters[n];
        }

        public void start() {
        }

        public void end() {
            for (Converter converter : this.elementConverters) {
                long l = -1L;
                ((ParquetColumnReaders.BaseColumnReader)converter).finalizeCurrentRow(l);
            }
            ++this.currentEntryIndex;
        }

        ColumnVector[] getDataVectors() {
            ColumnVector[] columnVectorArray = new ColumnVector[this.elementConverters.length];
            for (int i = 0; i < this.elementConverters.length; ++i) {
                columnVectorArray[i] = ((ParquetColumnReaders.BaseColumnReader)this.elementConverters[i]).getDataColumnVector(this.currentEntryIndex);
            }
            this.currentEntryIndex = 0;
            return columnVectorArray;
        }
    }
}

