/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.BaseImagesPusher;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesNamespacesService;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIContainersController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private KubernetesNamespacesService k8sNamespacesService;

    @AuditedCall(value={"msgType", "containers-list"})
    @RequestMapping(value={"/publicapi/container-exec/list-names"}, method={RequestMethod.GET})
    public void listContainersNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String type, @RequestParam(required=false) WorkloadType workloadType) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        List<ContainerExecRuntimeConfig.Container> filteredTypes = StringUtils.isBlank((String)type) ? Arrays.asList(ContainerExecRuntimeConfig.Container.values()) : Collections.singletonList(ContainerExecRuntimeConfig.Container.valueOf((String)type));
        PublicAPIContainersController.writeJSON((HttpServletResponse)resp, (Object)ContainerExecUtils.getAllowedContainerNames((AuthCtx)authCtx, filteredTypes, (WorkloadType)workloadType));
    }

    @AuditedCall(value={"msgType", "push-base-images"})
    @RequestMapping(value={"/publicapi/admin/container-exec/actions/push-base-images"}, method={RequestMethod.POST})
    public void pushBaseImages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        FutureResponse fr = this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<BaseImagesPusher.ImagePushResult>(authCtx){
            final DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            protected BaseImagesPusher.ImagePushResult compute() throws Exception {
                BaseImagesPusher bip = new BaseImagesPusher();
                SpringUtils.getInstance().autowire((Object)bip);
                return bip.tagAndPushAll(this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"push_container_exec_base_images", (String)"Push container-exec base images");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<BaseImagesPusher.ImagePushResult>>(){});
        PublicAPIContainersController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @RequestMapping(value={"/publicapi/admin/container-exec/actions/build-cde-plugins-image"}, method={RequestMethod.POST})
    @AuditedCall(value={"msgType", "build-cde-plugins-image"})
    public void buildCDEPluginsImage(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        BaseImageBuilder builder = new BaseImageBuilder(ContainerExecUtils.BaseImageType.CDE_PLUGINS, new BaseImageBuilder.BaseImageBuildOptions(), true);
        PublicAPIContainersController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.runFuture((FutureThreadBase)builder.getBuildFuture(authCtx), 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
    }

    @AuditedCall(value={"msgType", "admin-apply-kubernetes-policies"})
    @RequestMapping(value={"/publicapi/admin/container-exec/actions/apply-kubernetes-policies"})
    public void applyKubernetesPolicies(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        PublicAPIContainersController.writeJSON((HttpServletResponse)resp, (Object)this.k8sNamespacesService.applyAllPolicies(authCtx));
    }
}

