/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.connections.ConnectionsImportService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={""})
public class PublicAPIDatasetsTablesImportController
extends PublicAPIControllerBase {
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsImportService importService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.datasets");

    @AuditedCall(value={"msgType", "tables-import-prepare", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/tables-import/actions/list-schemas"}, method={RequestMethod.GET})
    public void listSchemas(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String connectionName) throws Exception {
        AbstractSQLConnection sqlConnection;
        AuthCtx authCtx;
        ConnectionsDAO.VirtualConnectionId virtualConnectionId = ConnectionsDAO.parseVirtualConnection((String)connectionName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (virtualConnectionId == null) {
                DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
                if (!(connection instanceof AbstractSQLConnection)) {
                    throw ErrorContext.iaef((String)"Expected SQL connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
                }
                if (!connection.isFreelyUsableBy(authCtx)) {
                    throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
                }
                sqlConnection = (AbstractSQLConnection)connection;
            } else {
                sqlConnection = null;
            }
        }
        if (virtualConnectionId == null) {
            PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)SQLUtils.listSchemasCatalogUnaware((SQLConnectionProvider.SQLConnectionData)sqlConnection.getConnectionData_NT(authCtx, projectKey), (AuthCtx)authCtx, (String)projectKey));
        } else {
            String clusterId = new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
            PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)this.metastoreInspectionService.newInspector(authCtx, projectKey).listHiveDatabase(clusterId, "default", authCtx, projectKey));
        }
    }

    @AuditedCall(value={"msgType", "tables-import-prepare", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/tables-import/actions/list-schemas-with-catalog"}, method={RequestMethod.GET})
    public void listSchemasWithCatalog(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String connectionName) throws Exception {
        List<SQLUtils.SQLSchema> schemas;
        AbstractSQLConnection sqlConnection;
        AuthCtx authCtx;
        ConnectionsDAO.VirtualConnectionId virtualConnectionId = ConnectionsDAO.parseVirtualConnection((String)connectionName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (virtualConnectionId == null) {
                DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
                if (!(connection instanceof AbstractSQLConnection)) {
                    throw ErrorContext.iaef((String)"Expected SQL connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
                }
                if (!connection.isFreelyUsableBy(authCtx)) {
                    throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
                }
                sqlConnection = (AbstractSQLConnection)connection;
            } else {
                sqlConnection = null;
            }
        }
        if (virtualConnectionId == null) {
            schemas = SQLUtils.listSchemasWithCatalogs((SQLConnectionProvider.SQLConnectionData)sqlConnection.getConnectionData_NT(authCtx, projectKey), (AuthCtx)authCtx, (String)projectKey);
        } else {
            schemas = new ArrayList();
            String clusterId = new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
            for (String database : this.metastoreInspectionService.newInspector(authCtx, projectKey).listHiveDatabase(clusterId, "default", authCtx, projectKey)) {
                schemas.add(new SQLUtils.SQLSchema(null, database));
            }
        }
        PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, schemas);
    }

    @AuditedCall(value={"msgType", "list-tables", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/tables-import/actions/list-tables"}, method={RequestMethod.GET})
    public void listTables(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String connectionName, @RequestParam(required=false) String catalogName, @RequestParam(required=false) String schemaName) throws Exception {
        AbstractSQLConnection sqlConnection;
        AuthCtx authCtx;
        ConnectionsDAO.VirtualConnectionId virtualConnectionId = ConnectionsDAO.parseVirtualConnection((String)connectionName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (virtualConnectionId == null) {
                DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
                if (!(connection instanceof AbstractSQLConnection)) {
                    throw ErrorContext.iaef((String)"Expected SQL connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
                }
                if (!connection.isFreelyUsableBy(authCtx)) {
                    throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
                }
                sqlConnection = (AbstractSQLConnection)connection;
            } else {
                sqlConnection = null;
            }
        }
        if (virtualConnectionId == null) {
            PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)this.importService.startListSQLTables(sqlConnection, catalogName, schemaName, authCtx, projectKey));
        } else {
            PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)this.importService.startListMetastoreTables(projectKey, authCtx, virtualConnectionId));
        }
    }

    @AuditedCall(value={"msgType", "list-indices", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/tables-import/actions/list-indices"}, method={RequestMethod.GET})
    public void listIndicesOrAliases(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String connectionName) throws Exception {
        ElasticSearchConnection elasticSearchConnection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
            if (!(connection instanceof ElasticSearchConnection)) {
                throw ErrorContext.iaef((String)"Expected ElasticSearch connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
            }
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
            }
            elasticSearchConnection = (ElasticSearchConnection)connection;
        }
        PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)this.importService.startListElasticSearchIndices(elasticSearchConnection, authCtx));
    }

    @AuditedCall(value={"msgType", "tables-import-prepare", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/tables-import/actions/prepare-from-keys"}, method={RequestMethod.POST})
    public void prepare(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ImportKeys keys = (ImportKeys)this.getRequestBodyAs(req, ImportKeys.class);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)this.importService.startGetTableImportCandidatesFromKeys_NT(projectKey, keys.keys, null, null, authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/tables-import/actions/execute-from-candidates"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ConnectionsImportService.TableImportCandidates candidates = (ConnectionsImportService.TableImportCandidates)this.getRequestBodyAs(req, ConnectionsImportService.TableImportCandidates.class);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        for (HiveImportabilityChecker.HiveTableImportCandidate hiveCandidate : candidates.hiveImportCandidates) {
            this.auditTrailService.generic("table-import-from-hive").with("projectKey", projectKey).with("datasetName", hiveCandidate.datasetName).with("hiveDatabaseName", hiveCandidate.databaseName).with("hiveTableName", hiveCandidate.table).emit();
        }
        for (ConnectionsImportService.SQLTableImportCandidate sqlCandidate : candidates.sqlImportCandidates) {
            this.auditTrailService.generic("table-import-from-sql").with("projectKey", projectKey).with("datasetName", sqlCandidate.datasetName).with("sourceConnection", sqlCandidate.connectionName).with("tableSchema", sqlCandidate.schema).with("tableName", sqlCandidate.table).emit();
        }
        for (ConnectionsImportService.ElasticSearchIndexImportCandidate candidate : candidates.elasticSearchImportCandidates) {
            this.auditTrailService.generic("table-import-from-elasticsearch").with("projectKey", projectKey).with("datasetName", candidate.datasetName).with("sourceConnection", candidate.connectionName).with("indexName", candidate.name).emit();
        }
        FutureResponse res = this.importService.massImportCandidates(projectKey, candidates.sqlImportCandidates, candidates.hiveImportCandidates, candidates.elasticSearchImportCandidates, authCtx, null);
        PublicAPIDatasetsTablesImportController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    static class ImportKeys {
        List<DatabaseObjectKey> keys = new ArrayList<DatabaseObjectKey>();

        ImportKeys() {
        }
    }
}

