/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BoostQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DisjunctionMaxQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MultiPhraseQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PhraseQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PrefixQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomMultiFieldQueryParser
extends MultiFieldQueryParser {
    protected static final DKULogger logger = DKULogger.getLogger((String)CustomMultiFieldQueryParser.class.getCanonicalName());
    private static final float TIE_BREAKER = 0.0f;
    private final Map<String, LuceneMappingsAnalyzer.Field> fieldsMapping;
    private final boolean analyzeWildcard;

    public CustomMultiFieldQueryParser(String[] fields, Analyzer analyzer, Map<String, Float> boosts, Map<String, LuceneMappingsAnalyzer.Field> fieldsMapping, boolean analyzeWildcard) {
        super(fields, analyzer, boosts);
        this.fieldsMapping = fieldsMapping;
        this.analyzeWildcard = analyzeWildcard;
        this.setEnablePositionIncrements(true);
    }

    private Query getDisjunctionMaxQuery(List<Query> queries) {
        if (queries.isEmpty()) {
            return null;
        }
        return queries.size() > 1 ? new DisjunctionMaxQuery(queries, 0.0f) : queries.get(0);
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        ArrayList<Query> queryList = new ArrayList<Query>();
        List<String> fieldList = this.getFields(field);
        for (String mField : fieldList) {
            Query q = this.getFieldQuerySingle(mField, queryText, slop);
            if (q == null) continue;
            if (fieldList.size() > 1) {
                q = this.applyBoost(q, mField);
            }
            q = this.applySlop(q, slop);
            queryList.add(q);
        }
        return this.getDisjunctionMaxQuery(queryList);
    }

    private Query getFieldQuerySingle(String field, String queryText, int slop) throws ParseException {
        return this.getFieldQuerySingle(field, queryText, true);
    }

    private List<String> getFields(String field) {
        return field == null ? List.of(this.fields) : List.of(field);
    }

    private Query applyBoost(Query q, String field) {
        Float boost;
        if (this.boosts != null && (boost = (Float)this.boosts.get(field)) != null && boost.floatValue() != 1.0f) {
            q = new BoostQuery(q, boost.floatValue());
        }
        return q;
    }

    private Query applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)q;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            q = builder.build();
        } else if (q instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)q;
            if (slop != mpq.getSlop()) {
                q = new MultiPhraseQuery.Builder(mpq).setSlop(slop).build();
            }
        } else if (q instanceof BoostQuery) {
            Query subQuery = ((BoostQuery)q).getQuery();
            subQuery = this.applySlop(subQuery, slop);
            q = new BoostQuery(subQuery, ((BoostQuery)q).getBoost());
        }
        return q;
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (field != null) {
            return this.getFieldQuerySingle(field, queryText, quoted);
        }
        if (this.fields.length == 1) {
            return this.getFieldQuerySingle(this.fields[0], queryText, quoted);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (String s : this.fields) {
            Query q = this.getFieldQuerySingle(s, queryText, quoted);
            if (q == null) continue;
            q = this.applyBoost(q, s);
            queries.add(new BooleanClause(q, BooleanClause.Occur.SHOULD).getQuery());
        }
        return this.getDisjunctionMaxQuery(queries);
    }

    private Query getFieldQuerySingle(String field, String queryText, boolean quoted) throws ParseException {
        if (this.fieldsMapping.containsKey(field)) {
            if (this.fieldsMapping.get((Object)field).restricted) {
                return new MatchNoDocsQuery();
            }
            if (this.fieldsMapping.get((Object)field).analyzer != null) {
                return super.getFieldQuery(field, queryText, quoted);
            }
            return new TermQuery(new Term(field, queryText));
        }
        return new TermQuery(new Term(field, queryText));
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        minSimilarity = 1.0f;
        if (field != null) {
            return this.getFuzzyQuerySingle(field, termStr, minSimilarity);
        }
        if (this.fields.length == 1) {
            return this.getFuzzyQuerySingle(this.fields[0], termStr, minSimilarity);
        }
        Map fields = this.boosts;
        if (fields.isEmpty()) {
            throw new IllegalStateException("No boost passed in input");
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry entry : fields.entrySet()) {
            Query q = this.getFuzzyQuerySingle((String)entry.getKey(), termStr, minSimilarity);
            if (q == null) continue;
            queries.add((Query)(((Float)entry.getValue()).floatValue() == 1.0f ? q : new BoostQuery(q, ((Float)entry.getValue()).floatValue())));
        }
        return this.getDisjunctionMaxQuery(queries);
    }

    private Query getFuzzyQuerySingle(String field, String termStr, float minSimilarity) {
        if (!this.fieldsMapping.containsKey(field)) {
            return this.newFuzzyQuery(new Term(field, termStr), minSimilarity, this.getFuzzyPrefixLength());
        }
        if (this.fieldsMapping.get((Object)field).restricted) {
            return new MatchNoDocsQuery();
        }
        return this.newFuzzyQuery(new Term(field, termStr.toLowerCase()), minSimilarity, this.getFuzzyPrefixLength());
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field != null) {
            return this.getPrefixQuerySingle(field, termStr);
        }
        if (this.fields.length == 1) {
            return this.getPrefixQuerySingle(this.fields[0], termStr);
        }
        Map fields = this.boosts;
        if (fields.isEmpty()) {
            throw new IllegalStateException("No boost passed in input");
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry entry : fields.entrySet()) {
            Query q = this.getPrefixQuerySingle((String)entry.getKey(), termStr);
            if (q == null) continue;
            if (((Float)entry.getValue()).floatValue() != 1.0f && this.analyzeWildcard) {
                q = new BoostQuery(q, ((Float)entry.getValue()).floatValue());
            }
            queries.add(q);
        }
        return this.getDisjunctionMaxQuery(queries);
    }

    private Query getPrefixQuerySingle(String field, String termStr) throws ParseException {
        List<String> termList;
        if (!this.fieldsMapping.containsKey(field)) {
            return new PrefixQuery(new Term(field, termStr));
        }
        if (this.fieldsMapping.get((Object)field).restricted) {
            return new MatchNoDocsQuery();
        }
        termStr = termStr.toLowerCase();
        if (!this.analyzeWildcard) {
            return super.getPrefixQuery(field, termStr);
        }
        List<String> list = termList = this.fieldsMapping.get((Object)field).analyzer != null ? this.extractTokens(field, termStr) : Arrays.asList(termStr);
        if (termList.size() == 1) {
            return new PrefixQuery(new Term(field, termList.get(0)));
        }
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        for (int i = 0; i < termList.size(); ++i) {
            if (i == termList.size() - 1) {
                bqb.add((Query)new PrefixQuery(new Term(field, termList.get(i))), BooleanClause.Occur.MUST);
                continue;
            }
            bqb.add((Query)new TermQuery(new Term(field, termList.get(i))), BooleanClause.Occur.MUST);
        }
        return bqb.build();
    }

    private List<String> extractTokens(String field, String termStr) {
        ArrayList<String> termList = new ArrayList<String>();
        try (TokenStream ts = this.getAnalyzer().tokenStream(field, termStr);){
            CharTermAttribute charTermAttribute = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String term = charTermAttribute.toString();
                termList.add(term);
            }
            ts.end();
        }
        catch (IOException e) {
            logger.error((Object)String.format("The token stream extraction failed for field [%s]: [%s]", field, termStr), (Throwable)e);
            return List.of(termStr);
        }
        if (termList.isEmpty()) {
            return List.of(termStr);
        }
        return termList;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if ("*".equals(termStr) && ("*".equals(field) || Objects.equals(field, this.field)) && (field == null || "*".equals(field))) {
            return this.newMatchAllDocsQuery();
        }
        return super.getWildcardQuery(field, termStr);
    }
}

