/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.annotation.JsonCreator;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.annotation.JsonProperty;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDSaveQueryRequest;
import com.treasuredata.client.model.TDSavedQuery;
import java.util.Objects;
import java.util.Optional;

public class TDSavedQueryUpdateRequest {
    private final Optional<String> name;
    private final Optional<String> cron;
    private final Optional<TDJob.Type> type;
    private final Optional<String> query;
    private final Optional<String> timezone;
    private final Optional<Long> delay;
    private final Optional<String> database;
    private final Optional<Integer> priority;
    private final Optional<Integer> retryLimit;
    private final Optional<String> result;
    private final Optional<TDJob.EngineVersion> engineVersion;

    @JsonCreator
    TDSavedQueryUpdateRequest(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="cron") Optional<String> cron, @JsonProperty(value="type") Optional<TDJob.Type> type, @JsonProperty(value="query") Optional<String> query, @JsonProperty(value="timezone") Optional<String> timezone, @JsonProperty(value="delay") Optional<Long> delay, @JsonProperty(value="database") Optional<String> database, @JsonProperty(value="priority") Optional<Integer> priority, @JsonProperty(value="retry_limit") Optional<Integer> retryLimit, @JsonProperty(value="result") Optional<String> result, @JsonProperty(value="engine_version") Optional<TDJob.EngineVersion> engineVersion) {
        this.name = name;
        this.cron = cron;
        this.type = type;
        this.query = query;
        this.timezone = timezone;
        this.delay = delay;
        this.database = database;
        this.priority = priority;
        this.retryLimit = retryLimit;
        this.result = result;
        this.engineVersion = engineVersion;
    }

    static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new Jdk8Module().configureAbsentsAsNulls(false));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return mapper;
    }

    public String toJson() {
        try {
            return TDSavedQueryUpdateRequest.getObjectMapper().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(String.format("Failed to produce json data of TDSavedQueryUpdateRequest: %s", this), e);
        }
    }

    public TDSaveQueryRequest merge(TDSavedQuery base) {
        return new TDSaveQueryRequest(this.name.orElse(base.getName()), this.cron.orElse(base.getCron()), this.type.orElse(base.getType()), this.query.orElse(base.getQuery()), this.timezone.orElse(base.getTimezone()), this.delay.orElse(base.getDelay()), this.database.orElse(base.getDatabase()), this.priority.orElse(base.getPriority()), this.retryLimit.orElse(base.getRetryLimit()), this.result.orElse(base.getResult()), this.engineVersion.isPresent() ? this.engineVersion.get() : base.getEngineVersion());
    }

    @JsonProperty
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty
    public Optional<String> getCron() {
        return this.cron;
    }

    @JsonProperty
    public Optional<TDJob.Type> getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getQuery() {
        return this.query;
    }

    @JsonProperty
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonProperty
    public Optional<Long> getDelay() {
        return this.delay;
    }

    @JsonProperty
    public Optional<String> getDatabase() {
        return this.database;
    }

    @JsonProperty
    public Optional<Integer> getPriority() {
        return this.priority;
    }

    @JsonProperty(value="retry_limit")
    public Optional<Integer> getRetryLimit() {
        return this.retryLimit;
    }

    @JsonProperty
    public Optional<String> getResult() {
        return this.result;
    }

    @JsonProperty(value="engine_version")
    public Optional<TDJob.EngineVersion> getEngineVersion() {
        return this.engineVersion;
    }

    public String toString() {
        return "TDSavedQueryUpdateRequest{name=" + this.name + ", cron=" + this.cron + ", type=" + this.type + ", query=" + this.query + ", timezone=" + this.timezone + ", delay=" + this.delay + ", database=" + this.database + ", priority=" + this.priority + ", retryLimit=" + this.retryLimit + ", result=" + this.result + ", engineVersion=" + this.engineVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TDSavedQueryUpdateRequest that = (TDSavedQueryUpdateRequest)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.cron, that.cron)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.query, that.query)) {
            return false;
        }
        if (!Objects.equals(this.timezone, that.timezone)) {
            return false;
        }
        if (!Objects.equals(this.delay, that.delay)) {
            return false;
        }
        if (!Objects.equals(this.database, that.database)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.retryLimit, that.retryLimit)) {
            return false;
        }
        if (!Objects.equals(this.engineVersion, that.engineVersion)) {
            return false;
        }
        return Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        int result1 = this.name != null ? this.name.hashCode() : 0;
        result1 = 31 * result1 + (this.cron != null ? this.cron.hashCode() : 0);
        result1 = 31 * result1 + (this.type != null ? this.type.hashCode() : 0);
        result1 = 31 * result1 + (this.query != null ? this.query.hashCode() : 0);
        result1 = 31 * result1 + (this.timezone != null ? this.timezone.hashCode() : 0);
        result1 = 31 * result1 + (this.delay != null ? this.delay.hashCode() : 0);
        result1 = 31 * result1 + (this.database != null ? this.database.hashCode() : 0);
        result1 = 31 * result1 + (this.priority != null ? this.priority.hashCode() : 0);
        result1 = 31 * result1 + (this.retryLimit != null ? this.retryLimit.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        result1 = 31 * result1 + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
        return result1;
    }
}

