/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileInputFormat;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileOutputFormat;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.spark.WriteMode$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class HDFSDatasetRDD$ {
    public static HDFSDatasetRDD$ MODULE$;
    private final Logger logger;

    static {
        new HDFSDatasetRDD$();
    }

    public boolean isDirectInputPathsEnabled(SparkContext sc) {
        boolean value;
        block0: {
            String key = "spark.dku.fill.inputpaths";
            value = new StringOps(Predef$.MODULE$.augmentString(sc.getConf().get(key, "true"))).toBoolean();
            if (value) break block0;
            this.logger().info((Object)"Direct input paths filling disabled");
        }
        return value;
    }

    public void fillInputPaths(Seq<String> paths, Job job, SparkContext sc) {
        if (this.isDirectInputPathsEnabled(sc)) {
            String inputDirProp = ((TraversableOnce)paths.map((Function1 & Serializable & scala.Serializable)x$1 -> StringUtils.escapeString((String)x$1), Seq$.MODULE$.canBuildFrom())).mkString(",");
            this.logger().debug((Object)new StringBuilder(21).append("Setting input paths: ").append(inputDirProp).toString());
            job.getConfiguration().set("mapreduce.input.fileinputformat.inputdir", inputDirProp);
            return;
        }
        paths.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HDFSDatasetRDD$.$anonfun$fillInputPaths$2(job, f);
            return BoxedUnit.UNIT;
        });
    }

    public RDD<RowWithFactories> getHadoopRDDForHDFSable(HDFSableDatasetHandler handler, SparkContext sc, List<String> partitions) {
        Dataset dataset = handler.getDataset();
        Job job = Job.getInstance((Configuration)sc.hadoopConfiguration());
        Configuration jobConf = job.getConfiguration();
        handler.addExtraConf(jobConf, false);
        UniversalFileInputFormat.setInputDatasetConfig((Configuration)jobConf, (DatasetConfig)new DatasetConfig(dataset.serialize()));
        this.fillInputPaths(this.listFilesForHDFSable(handler, partitions), job, sc);
        return sc.newAPIHadoopRDD(jobConf, UniversalFileInputFormat.class, Void.class, RowWithFactories.class).map((Function1 & Serializable & scala.Serializable)x$1 -> (RowWithFactories)x$1._2(), ClassTag$.MODULE$.apply(RowWithFactories.class));
    }

    /*
     * Unable to fully structure code
     */
    public void saveHadoopRDDForHDFSable(HDFSableDatasetHandler handler, RDD<RowWithFactories> rdd, String targetPartition, Enumeration.Value writeMode) {
        dataset = handler.getDataset();
        partition = targetPartition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)targetPartition) : null;
        config = new Configuration(rdd.sparkContext().hadoopConfiguration());
        handler.addExtraConf(config, false);
        UniversalFileOutputFormat.setOutputDatasetConfig((Configuration)config, (DatasetConfig)new DatasetConfig(dataset.serialize()));
        var9_8 = false;
        var10_9 = null;
        var11_10 = writeMode;
        v0 = WriteMode$.MODULE$.Overwrite();
        var12_11 = var11_10;
        if (v0 != null ? v0.equals(var12_11) == false : var12_11 != null) ** GOTO lbl-1000
        var9_8 = true;
        var10_9 = var11_10;
        if (partition != null) {
            handler.clearPartitions(JavaConversions$.MODULE$.seqAsJavaList((Seq)new .colon.colon((Object)partition, (List)Nil$.MODULE$)));
        } else if (var9_8 && partition == null) {
            handler.clearAllData();
        } else {
            v1 = WriteMode$.MODULE$.Append();
            var13_12 = var11_10;
            if (!(v1 != null ? v1.equals(var13_12) == false : var13_12 != null)) {
            } else {
                throw new MatchError((Object)var11_10);
            }
        }
        path = partition != null ? handler.getFullyQualifiedPartitionPath(partition) : handler.getFullyQualifiedRootPath();
        this.logger().info((Object)new StringBuilder(14).append("Saving RDD to ").append(path).toString());
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveHadoopRDDForHDFSable$1(com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories ), (Lcom/dataiku/dip/shaker/mrimpl/formats/RowWithFactories;)Lscala/Tuple2;)(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.apply(RowWithFactories.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(path, Void.class, RowWithFactories.class, UniversalFileOutputFormat.class, config);
    }

    public Seq<String> listFilesForHDFSableRaw(HDFSableDatasetHandler handler, List<String> partitions) {
        Dataset dataset = handler.getDataset();
        String rootPath = handler.getFullyQualifiedRootPath();
        if (handler.isSingleFile()) {
            return (Seq)new .colon.colon((Object)rootPath, (List)Nil$.MODULE$);
        }
        Seq filesEnumeration = !dataset.getPartitioningSchema().isPartitioned() || partitions == null ? (Seq)JavaConversions$.MODULE$.asScalaBuffer(handler.enumerateFilesystem()).map((Function1 & Serializable & scala.Serializable)dssPath -> new StringBuilder(0).append(rootPath).append(dssPath.path()).toString(), Buffer$.MODULE$.canBuildFrom()) : (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)pspec -> (Buffer)JavaConversions$.MODULE$.asScalaBuffer(PartitionFactory.fromPartitionSpec((PartitioningScheme)dataset.getPartitioningSchema(), (String)pspec)).flatMap((Function1 & Serializable & scala.Serializable)part -> (Buffer)JavaConversions$.MODULE$.asScalaBuffer(handler.enumeratePartition(part, handler.getEnumerationSettings())).map((Function1 & Serializable & scala.Serializable)dssPath -> new StringBuilder(0).append(rootPath).append(dssPath.path()).toString(), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return filesEnumeration;
    }

    public Seq<String> listFilesForHDFSable(HDFSableDatasetHandler handler, List<String> partitions) {
        Seq<String> filesEnumeration = this.listFilesForHDFSableRaw(handler, partitions);
        if (filesEnumeration.length() == 1) {
            return filesEnumeration;
        }
        Dataset dataset = handler.getDataset();
        if (dataset.getDkuPropertiesAsParams().getBoolParam("try.use.foldersInsteadOfPaths", true)) {
            FilesSelectionRules.Mode mode = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).filesSelectionRules.mode;
            FilesSelectionRules.Mode mode2 = FilesSelectionRules.Mode.ALL;
            if (!(mode != null ? !mode.equals(mode2) : mode2 != null)) {
                List filesEnumerationFlat = filesEnumeration.toList();
                Set parents = ((TraversableOnce)filesEnumerationFlat.map((Function1 & Serializable & scala.Serializable)path -> PathUtils.getParent((String)path), List$.MODULE$.canBuildFrom())).toSet();
                boolean overlaps = parents.exists((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)parents.exists((Function1 & Serializable & scala.Serializable)parent -> BoxesRunTime.boxToBoolean((boolean)HDFSDatasetRDD$.$anonfun$listFilesForHDFSable$3(child, parent)))));
                if (overlaps) {
                    this.logger().info((Object)new StringBuilder(68).append("Tried to use ").append(parents.size()).append(" folders instead of ").append(filesEnumerationFlat.size()).append(" file paths, but there are overlaps").toString());
                    return filesEnumerationFlat;
                }
                this.logger().info((Object)new StringBuilder(37).append("Using ").append(parents.size()).append(" folders instead of ").append(filesEnumerationFlat.size()).append(" file paths").toString());
                return parents.toSeq();
            }
        }
        this.logger().info((Object)"Not trying to use folders instead of file paths, files are selected with a filter");
        return filesEnumeration;
    }

    public RDD<RowWithFactories> getHadoopRDD(HDFSDatasetHandler handler, SparkContext sc, List<String> partitions) {
        Dataset dataset = handler.getDataset();
        Job job = Job.getInstance((Configuration)sc.hadoopConfiguration());
        Configuration jobConf = job.getConfiguration();
        ArrayBuffer configKeys = new ArrayBuffer();
        ArrayBuffer resourceJars = new ArrayBuffer();
        UniversalFileInputFormat.setInputDatasetConfig((Configuration)jobConf, (DatasetConfig)new DatasetConfig(dataset.serialize()));
        UniversalFileInputFormat.registerDependencies((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset, (java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)configKeys).asJava()), (java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)resourceJars).asJava()));
        handler.addExtraConf(jobConf, false);
        configKeys.foreach((Function1 & Serializable & scala.Serializable)configKey -> {
            jobConf.set(configKey.key, configKey.value);
            return BoxedUnit.UNIT;
        });
        resourceJars.foreach((Function1 & Serializable & scala.Serializable)resourceJar -> {
            sc.addJar(resourceJar.getAbsolutePath());
            return BoxedUnit.UNIT;
        });
        this.fillInputPaths(this.listDirectories((HDFSableDatasetHandler)handler, partitions), job, sc);
        this.logger().info((Object)"Getting RDD");
        return sc.newAPIHadoopRDD(jobConf, UniversalFileInputFormat.class, Void.class, RowWithFactories.class).map((Function1 & Serializable & scala.Serializable)x$3 -> (RowWithFactories)x$3._2(), ClassTag$.MODULE$.apply(RowWithFactories.class));
    }

    public List<String> getHadoopRDDForHDFSable$default$3() {
        return null;
    }

    public List<String> getHadoopRDD$default$3() {
        return null;
    }

    public void saveHadoopRDD(HDFSDatasetHandler handler, RDD<RowWithFactories> rdd, String targetPartition, Enumeration.Value writeMode, String apiTicket) {
        Dataset dataset = handler.getDataset();
        Partition partition = targetPartition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)targetPartition) : null;
        Configuration config = new Configuration(rdd.sparkContext().hadoopConfiguration());
        ArrayBuffer configKeys = new ArrayBuffer();
        ArrayBuffer resourceJars = new ArrayBuffer();
        UniversalFileOutputFormat.setOutputDatasetConfig((Configuration)config, (DatasetConfig)new DatasetConfig(dataset.serialize()));
        UniversalFileOutputFormat.registerDependencies((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset, (java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)configKeys).asJava()), (java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)resourceJars).asJava()));
        handler.addExtraConf(config, false);
        configKeys.foreach((Function1 & Serializable & scala.Serializable)configKey -> {
            config.set(configKey.key, configKey.value);
            return BoxedUnit.UNIT;
        });
        resourceJars.foreach((Function1 & Serializable & scala.Serializable)resourceJar -> {
            HDFSDatasetRDD$.$anonfun$saveHadoopRDD$2(rdd, resourceJar);
            return BoxedUnit.UNIT;
        });
        this.clearDataset(dataset, partition, writeMode, apiTicket);
        String path = partition != null ? handler.getFullyQualifiedHDFSPath(handler.getPartitionPath(partition)) : handler.getFullyQualifiedRootPath();
        this.logger().info((Object)new StringBuilder(14).append("Saving RDD to ").append(path).toString());
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1 & Serializable & scala.Serializable)x$4 -> new Tuple2(null, x$4), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.apply(RowWithFactories.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(path, Void.class, RowWithFactories.class, UniversalFileOutputFormat.class, config);
    }

    public Enumeration.Value saveHadoopRDDForHDFSable$default$4() {
        return WriteMode$.MODULE$.Overwrite();
    }

    public Enumeration.Value saveHadoopRDD$default$4() {
        return WriteMode$.MODULE$.Overwrite();
    }

    public SaveMode clearDataset(Dataset dataset, Partition partition, Enumeration.Value writeMode, String apiTicket) {
        boolean bl = false;
        Enumeration.Value value = null;
        Enumeration.Value value2 = writeMode;
        Enumeration.Value value3 = WriteMode$.MODULE$.Overwrite();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            bl = true;
            value = value2;
            if (partition != null) {
                StdDataikuSparkContext$.MODULE$.executeCommand("datasets/clear-partition/", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectKey"), (Object)dataset.getProjectKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)dataset.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)partition.id())}))), apiTicket, ClassTag$.MODULE$.Nothing());
                return SaveMode.Overwrite;
            }
        }
        if (bl && partition == null) {
            StdDataikuSparkContext$.MODULE$.executeCommand("datasets/clear/", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectKey"), (Object)dataset.getProjectKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)dataset.getName())}))), apiTicket, ClassTag$.MODULE$.Nothing());
            return SaveMode.Overwrite;
        }
        Enumeration.Value value5 = WriteMode$.MODULE$.Append();
        Enumeration.Value value6 = value2;
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            return SaveMode.Append;
        }
        throw new MatchError((Object)value2);
    }

    public Iterator<Row> extractRows(List<String> columnNames, List<SchemaColumn> schemaColumns, String filterExpression, Iterator<RowWithFactories> rddPartition) {
        Expression expression = filterExpression != null ? new Expression(filterExpression, new Schema((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(schemaColumns).asJava(), false)) : null;
        ObjectRef columns = ObjectRef.create(null);
        IntRef failedRows = IntRef.create((int)0);
        return rddPartition.flatMap((Function1 & Serializable & scala.Serializable)rwf -> {
            Iterable iterable;
            block6: {
                if ((List)columns$1.elem == null) {
                    ColumnFactory cf = rwf.getColumnFactory();
                    columns$1.elem = (List)schemaColumns.map((Function1 & Serializable & scala.Serializable)sc -> new Tuple2((Object)cf.column(sc.getName()), sc), List$.MODULE$.canBuildFrom());
                    if (expression != null) {
                        expression.setColumnFactory(cf);
                    }
                }
                try {
                    com.dataiku.dip.datalayer.Row row = rwf.getRow();
                    if (expression != null && !BoxesRunTime.equals((Object)expression.evaluate(row), (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        break block6;
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Row$.MODULE$.fromSeq((Seq)((List)columns$1.elem).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSDatasetRDD$.$anonfun$extractRows$3(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
                        Tuple2 tuple2 = x$5;
                        if (tuple2 != null) {
                            Column c = (Column)tuple2._1();
                            SchemaColumn t = (SchemaColumn)tuple2._2();
                            return package$.MODULE$.dkuToSpark(row.get(c), t);
                        }
                        throw new MatchError((Object)tuple2);
                    }, List$.MODULE$.canBuildFrom()))));
                }
                catch (Exception e) {
                    if (failedRows$1.elem < 2) {
                        MODULE$.logger().warn((Object)"Failed to load row", (Throwable)e);
                    }
                    ++failedRows$1.elem;
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            return iterable;
        });
    }

    public Iterator<List<String>> filterRows(List<String> columnNames, List<SchemaColumn> schemaColumns, String filterExpression, Iterator<RowWithFactories> rddPartition) {
        Expression expression = filterExpression != null ? new Expression(filterExpression, new Schema((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(schemaColumns).asJava(), false)) : null;
        ObjectRef columns = ObjectRef.create(null);
        IntRef failedRows = IntRef.create((int)0);
        return rddPartition.flatMap((Function1 & Serializable & scala.Serializable)rwf -> {
            Iterable iterable;
            block6: {
                if ((List)columns$2.elem == null) {
                    ColumnFactory cf = rwf.getColumnFactory();
                    columns$2.elem = (List)schemaColumns.map((Function1 & Serializable & scala.Serializable)sc -> cf.column(sc.getName()), List$.MODULE$.canBuildFrom());
                    if (expression != null) {
                        expression.setColumnFactory(cf);
                    }
                }
                try {
                    com.dataiku.dip.datalayer.Row row = rwf.getRow();
                    if (expression != null && !BoxesRunTime.equals((Object)expression.evaluate(row), (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        break block6;
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some(((List)columns$2.elem).map((Function1 & Serializable & scala.Serializable)x$6 -> row.get(x$6), List$.MODULE$.canBuildFrom())));
                }
                catch (Exception e) {
                    if (failedRows$2.elem < 2) {
                        MODULE$.logger().warn((Object)"Failed to load row", (Throwable)e);
                    }
                    ++failedRows$2.elem;
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            return iterable;
        });
    }

    public Seq<String> listDirectories(HDFSableDatasetHandler handler, List<String> partitions) {
        Dataset dataset = handler.getDataset();
        if (!dataset.getPartitioningSchema().isPartitioned()) {
            return (Seq)new .colon.colon((Object)handler.getFullyQualifiedRootPath(), (List)Nil$.MODULE$);
        }
        if (partitions != null) {
            return (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)pspec -> (Buffer)JavaConversions$.MODULE$.asScalaBuffer(PartitionFactory.fromPartitionSpec((PartitioningScheme)dataset.getPartitioningSchema(), (String)pspec)).map((Function1 & Serializable & scala.Serializable)part -> handler.getFullyQualifiedPartitionPath(part), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        }
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(handler.listPartitions()).map((Function1 & Serializable & scala.Serializable)part -> handler.getFullyQualifiedPartitionPath(part), Buffer$.MODULE$.canBuildFrom());
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ void $anonfun$fillInputPaths$2(Job job$1, String f) {
        MODULE$.logger().debug((Object)new StringBuilder(19).append("Adding input path: ").append(f).toString());
        FileInputFormat.addInputPath((Job)job$1, (Path)new Path(f));
    }

    public static final /* synthetic */ Tuple2 $anonfun$saveHadoopRDDForHDFSable$1(RowWithFactories x$2) {
        return new Tuple2(null, (Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$listFilesForHDFSable$3(String child$1, String parent) {
        return child$1.length() > parent.length() && child$1.startsWith(parent);
    }

    public static final /* synthetic */ void $anonfun$saveHadoopRDD$2(RDD rdd$1, File resourceJar) {
        rdd$1.context().addJar(resourceJar.getAbsolutePath());
    }

    public static final /* synthetic */ boolean $anonfun$extractRows$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private HDFSDatasetRDD$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.dataset.hdfs");
    }
}

