/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SQLFastpathSupport$ {
    public static SQLFastpathSupport$ MODULE$;
    private final Logger logger;

    static {
        new SQLFastpathSupport$();
    }

    public org.apache.spark.sql.Dataset<Row> fixupPartitioning(Dataset dataset, org.apache.spark.sql.Dataset<Row> dataFrame, String partition) {
        PartitioningScheme partitioningSchema = dataset.getPartitioningSchema();
        if (partitioningSchema.isPartitioned() && dataFrame.schema().length() != dataset.getSchema().columns.size()) {
            Partition targetPartition = PartitionFactory.fromIdentifier((PartitioningScheme)partitioningSchema, (String)partition);
            Set dataFrameColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
            Set datasetColumns = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(dataset.getSchema().getColumns()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set partitioningColumns = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(targetPartition.getDimensionValues()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> (String)e._1(), Iterable$.MODULE$.canBuildFrom())).toSet();
            Set addableColumns = (Set)partitioningColumns.$minus$minus((GenTraversableOnce)dataFrameColumns);
            Set missingDatasetColumns = (Set)addableColumns.$minus$minus((GenTraversableOnce)datasetColumns);
            if (!missingDatasetColumns.isEmpty()) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, new StringBuilder(56).append("Dataset '").append(dataset.getName()).append("' does not contain the partitioning column(s): ").append(missingDatasetColumns.mkString(", ")).toString());
            }
            return (org.apache.spark.sql.Dataset)addableColumns.foldLeft(dataFrame, (Function2 & Serializable & scala.Serializable)(df, dimensionName) -> {
                DimensionValue dimensionValue = (DimensionValue)targetPartition.getDimensionValues().get(dimensionName);
                SchemaColumn partitionColumn = dataset.getSchema().getColumn(dimensionName);
                String partitionValue = ExpressionUtils.getStringForDimensionValue((DimensionValue)dimensionValue, (Type)partitionColumn.getType());
                DataType dataType = package$.MODULE$.dkuToSpark(partitionColumn).dataType();
                return df.withColumn(dimensionName, functions$.MODULE$.lit((Object)partitionValue).cast(dataType));
            });
        }
        return dataFrame;
    }

    public void saveSQLDataset(AbstractSQLTableDatasetHandler datasetHandler, org.apache.spark.sql.Dataset<Row> dataFrame, String partition, Enumeration.Value writeMode, String apiTicket) {
        scala.collection.immutable.Map map;
        Dataset dataset = datasetHandler.getDataset();
        StdDataikuSparkContext$.MODULE$.executeCommand("datasets/prepare-sql-table-for-write/", (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectKey"), (Object)dataset.getProjectKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)dataset.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)partition), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeMode"), (Object)writeMode.toString())}))), apiTicket, ClassTag$.MODULE$.apply(InfoMessage.InfoMessages.class));
        org.apache.spark.sql.Dataset<Row> df = this.fixupPartitioning(dataset, dataFrame, partition);
        SQLConnectionProvider.SQLConnectionData connData = datasetHandler.getConnectionData();
        SQLDialect dialect = connData.getDialect();
        SQLConnectionProvider.SparkJDBCInfo connectionInfo = connData.getSparkConnectionInfo(datasetHandler.getAuthCtx(), dataset.getProjectKey());
        scala.collection.immutable.Map connectionOptions = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(connectionInfo.properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n.toString()), (Object)connectionInfo$1.properties.getProperty((String)n).toString()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map datasetOptions = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(datasetHandler.getSparkConnectionInfo()).asScala();
        String string = "partitionColumn";
        String string2 = "lowerBound";
        String string3 = "upperBound";
        List writeForbiddenOptions = Nil$.MODULE$.$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string);
        scala.collection.immutable.Map allOptions = ((TraversableOnce)((TraversableLike)connectionOptions.toSeq().$plus$plus((GenTraversableOnce)datasetOptions.toSet(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SQLFastpathSupport$.$anonfun$saveSQLDataset$2(writeForbiddenOptions, e)))).toMap(Predef$.MODULE$.$conforms());
        if (new StringOps(Predef$.MODULE$.augmentString((String)allOptions.getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "0"))).toInt() < 0) {
            int numExecutors = new StringOps(Predef$.MODULE$.augmentString(df.sqlContext().sparkContext().getConf().get("spark.executor.instances", "1"))).toInt();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numPartitions"), (Object)Integer.toString(numExecutors));
            map = ((TraversableOnce)((MapLike)allOptions.filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)SQLFastpathSupport$.$anonfun$saveSQLDataset$4(kv)))).toSeq().$plus$plus((GenTraversableOnce)Nil$.MODULE$.$colon$colon((Object)tuple2), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = allOptions;
        }
        scala.collection.immutable.Map allOptionsWithNumPartitions = map;
        df.write().format("jdbc").options((Map)allOptionsWithNumPartitions).option("url", connectionInfo.url).option("driver", connectionInfo.driver).option("dbtable", dialect.quoteIdentifier(datasetHandler.getResolvedTable().getTable())).mode(SaveMode.Append).save();
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ boolean $anonfun$saveSQLDataset$2(List writeForbiddenOptions$1, Tuple2 e) {
        return !writeForbiddenOptions$1.contains(e._1());
    }

    public static final /* synthetic */ boolean $anonfun$saveSQLDataset$4(Tuple2 kv) {
        return !"numPartitions".equals(kv._1());
    }

    private SQLFastpathSupport$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.sql");
    }
}

