/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public final class IntervalTree<RangeType extends Range<RangeType, ScalarType>, ScalarType> {
    private final TreeNode<RangeType, ScalarType> root;
    private final int nodeCount;

    private IntervalTree(TreeNode<RangeType, ScalarType> tn, int count) {
        this.root = tn;
        this.nodeCount = count;
    }

    private static <RangeType extends Range<RangeType, ScalarType>, ScalarType> TreeNode<RangeType, ScalarType> build(RangeType[] elements, int firstIdx, int lastIdx) {
        if (firstIdx == lastIdx) {
            return null;
        }
        int middleIdx = (firstIdx + lastIdx) / 2;
        RangeType range = elements[middleIdx];
        TreeNode left = IntervalTree.build(elements, (int)firstIdx, (int)middleIdx);
        TreeNode right = IntervalTree.build(elements, (int)(middleIdx + 1), (int)lastIdx);
        RangeType upper = range;
        if (left != null && left.upper.compareUpperBoundToRange(upper) > 0) {
            upper = left.upper;
        }
        if (right != null && right.upper.compareUpperBoundToRange(upper) > 0) {
            upper = right.upper;
        }
        return new TreeNode(left, right, upper, range);
    }

    public static <RangeType extends Range<RangeType, ScalarType>, ScalarType> IntervalTree<RangeType, ScalarType> build(Collection<RangeType> elements) {
        Range[] sortedRanges = elements.toArray((Range[])Array.newInstance(Range.class, elements.size()));
        Arrays.sort(sortedRanges, new Comparator<RangeType>(){

            @Override
            public int compare(RangeType t, RangeType t2) {
                int test = t.compareLowerBoundToRange(t2);
                if (test == 0) {
                    test = t.compareUpperBoundToRange(t2);
                }
                return test;
            }
        });
        TreeNode root = IntervalTree.build((Range[])sortedRanges, (int)0, (int)sortedRanges.length);
        return new IntervalTree<RangeType, ScalarType>(root, sortedRanges.length);
    }

    private <T extends Throwable> int search(TreeNode<RangeType, ScalarType> tn, ScalarType value, ThrowingVisitor<RangeType, T> visitor) throws T {
        int visitedNodeCount = 0;
        if (tn == null) {
            return visitedNodeCount;
        }
        ++visitedNodeCount;
        if (tn.range.compareLowerBoundToScalar(value) <= 0 && tn.range.compareUpperBoundToScalar(value) > 0) {
            visitor.visit(tn.range);
        }
        if (tn.upper.compareUpperBoundToScalar(value) <= 0) {
            return visitedNodeCount;
        }
        visitedNodeCount += this.search(tn.left, value, visitor);
        if (tn.range.compareLowerBoundToScalar(value) > 0) {
            return visitedNodeCount;
        }
        return visitedNodeCount += this.search(tn.right, value, visitor);
    }

    private <T extends Throwable> void visit(TreeNode<RangeType, ScalarType> tn, ThrowingVisitor<RangeType, T> visitor) throws T {
        if (tn == null) {
            return;
        }
        this.visit(tn.left, visitor);
        visitor.visit(tn.range);
        this.visit(tn.right, visitor);
    }

    public <T extends Throwable> void visit(ThrowingVisitor<RangeType, T> visitor) throws T {
        this.visit(this.root, visitor);
    }

    public <T extends Throwable> int search(ScalarType value, ThrowingVisitor<RangeType, T> visitor) throws T {
        return this.search(this.root, value, visitor);
    }

    public <T extends Throwable> int searchForPeriod(ScalarType lowerBound, ScalarType upperBound, ThrowingVisitor<RangeType, T> visitor) throws T {
        return this.searchForPeriod(this.root, lowerBound, upperBound, visitor);
    }

    private <T extends Throwable> int searchForPeriod(TreeNode<RangeType, ScalarType> tn, ScalarType lowerBound, ScalarType upperBound, ThrowingVisitor<RangeType, T> visitor) throws T {
        boolean nodeEndsAfterLowerBound;
        int visitedNodeCount = 0;
        if (tn == null) {
            return visitedNodeCount;
        }
        ++visitedNodeCount;
        if (tn.upper.compareUpperBoundToScalar(lowerBound) <= 0) {
            return visitedNodeCount;
        }
        visitedNodeCount += this.searchForPeriod(tn.left, lowerBound, upperBound, visitor);
        boolean nodeStartsBeforeUpperBound = tn.range.compareLowerBoundToScalar(upperBound) < 0;
        boolean bl = nodeEndsAfterLowerBound = tn.range.compareUpperBoundToScalar(lowerBound) > 0;
        if (nodeStartsBeforeUpperBound && nodeEndsAfterLowerBound) {
            visitor.visit(tn.range);
        }
        if (nodeStartsBeforeUpperBound) {
            visitedNodeCount += this.searchForPeriod(tn.right, lowerBound, upperBound, visitor);
        }
        return visitedNodeCount;
    }

    public int size() {
        return this.nodeCount;
    }

    private static class TreeNode<RangeType extends Range<RangeType, ScalarType>, ScalarType> {
        private final TreeNode<RangeType, ScalarType> left;
        private final TreeNode<RangeType, ScalarType> right;
        private final RangeType upper;
        private final RangeType range;

        private TreeNode(TreeNode<RangeType, ScalarType> left, TreeNode<RangeType, ScalarType> right, RangeType upper, RangeType range) {
            this.left = left;
            this.right = right;
            this.upper = upper;
            this.range = range;
        }
    }

    public static interface Range<RangeType extends Range<RangeType, ScalarType>, ScalarType> {
        public int compareLowerBoundToRange(RangeType var1);

        public int compareUpperBoundToRange(RangeType var1);

        public int compareLowerBoundToScalar(ScalarType var1);

        public int compareUpperBoundToScalar(ScalarType var1);
    }

    public static interface ThrowingVisitor<RangeType, T extends Throwable> {
        public void visit(RangeType var1) throws T;
    }

    public static interface Visitor<RangeType>
    extends ThrowingVisitor<RangeType, RuntimeException> {
    }
}

