/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth.keyvalue;

import com.twitter.joauth.UrlCodec;

public interface Transformer {
    public static final Transformer TRIM_TRANSFORMER = new TrimTransformer();
    public static final Transformer URL_ENCODING_NORMALIZING_TRANSFORMER = new UrlEncodingNormalizingTransformer();

    public String transform(String var1);

    public static class UrlEncodingNormalizingTransformer
    implements Transformer {
        @Override
        public String transform(String input) {
            return UrlCodec.normalize(input);
        }
    }

    public static class TrimTransformer
    implements Transformer {
        @Override
        public String transform(String input) {
            return input.trim();
        }
    }
}

