/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest;

import com.dataiku.dss.shadelibazure.com.azure.core.exception.HttpResponseException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectionUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectiveInvoker;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ResponseExceptionConstructorCache {
    private static final Map<Class<? extends HttpResponseException>, ReflectiveInvoker> CACHE = new ConcurrentHashMap<Class<? extends HttpResponseException>, ReflectiveInvoker>();
    private static final ClientLogger LOGGER = new ClientLogger(ResponseExceptionConstructorCache.class);

    public ReflectiveInvoker get(Class<? extends HttpResponseException> exceptionClass, Class<?> exceptionBodyType) {
        return CACHE.computeIfAbsent(exceptionClass, key -> ResponseExceptionConstructorCache.locateExceptionConstructor(key, exceptionBodyType));
    }

    private static ReflectiveInvoker locateExceptionConstructor(Class<? extends HttpResponseException> exceptionClass, Class<?> exceptionBodyType) {
        try {
            return ReflectionUtils.getConstructorInvoker(exceptionClass, exceptionClass.getConstructor(String.class, HttpResponse.class, exceptionBodyType));
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)ex);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(ex));
        }
    }

    static <T extends HttpResponseException> T invoke(ReflectiveInvoker reflectiveInvoker, String exceptionMessage, HttpResponse httpResponse, Object exceptionBody) {
        try {
            return (T)((HttpResponseException)reflectiveInvoker.invokeStatic(exceptionMessage, httpResponse, exceptionBody));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException(exceptionMessage, exception));
        }
    }
}

