/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuples;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class StreamUtil {
    private static final ClientLogger LOGGER = new ClientLogger(StreamUtil.class);

    private StreamUtil() {
    }

    public static Tuple2<Long, List<ByteBuffer>> readStreamToListOfByteBuffers(InputStream inputStream2, Long lengthHint, int initialBufferSize, int maxBufferSize) throws IOException {
        int read;
        Objects.requireNonNull(inputStream2, "'inputStream' must not be null");
        if (initialBufferSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'initialBufferSize' must be positive integer"));
        }
        if (maxBufferSize < initialBufferSize) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maxBufferSize' must not be smaller than 'maxBufferSize'"));
        }
        if (lengthHint != null && lengthHint < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'length' must not be negative"));
        }
        int chunkSize = initialBufferSize;
        if (lengthHint != null) {
            chunkSize = (int)Math.max(1L, Math.min((long)maxBufferSize, lengthHint));
        }
        long totalRead = 0L;
        long actualLength = lengthHint != null ? lengthHint : Long.MAX_VALUE;
        ReadableByteChannel channel = Channels.newChannel(inputStream2);
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        ByteBuffer chunk = ByteBuffer.allocate(chunkSize);
        do {
            if ((read = channel.read(chunk)) >= 0) {
                totalRead += (long)read;
                if (chunk.hasRemaining()) continue;
                int nextChunkSizeCandidate = 2 * chunkSize;
                if ((long)nextChunkSizeCandidate <= actualLength - totalRead && nextChunkSizeCandidate <= maxBufferSize) {
                    chunkSize = nextChunkSizeCandidate;
                }
                chunk.flip();
                buffers.add(chunk);
                if (totalRead == actualLength) {
                    ByteBuffer eofCheckBuffer = ByteBuffer.allocate(1);
                    read = channel.read(eofCheckBuffer);
                    if (read != -1) {
                        chunk = ByteBuffer.allocate(chunkSize);
                        eofCheckBuffer.flip();
                        chunk.put(eofCheckBuffer);
                        continue;
                    }
                    chunk = null;
                    continue;
                }
                chunk = ByteBuffer.allocate(chunkSize);
                continue;
            }
            chunk.flip();
            if (!chunk.hasRemaining()) continue;
            buffers.add(chunk);
        } while (read >= 0);
        return Tuples.of(totalRead, Collections.unmodifiableList(buffers));
    }
}

