/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.logging;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.logging.LoggingUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonProviders;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.org.slf4j.Logger;
import com.dataiku.dss.shadelibazure.org.slf4j.helpers.FormattingTuple;
import com.dataiku.dss.shadelibazure.org.slf4j.helpers.MessageFormatter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class LoggingEventBuilder {
    private static final LoggingEventBuilder NOOP = new LoggingEventBuilder(null, null, null, false);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Logger logger;
    private final LogLevel level;
    private List<ContextKeyValuePair> context;
    private final Map<String, Object> globalContext;
    private final boolean hasGlobalContext;
    private final boolean isEnabled;

    static LoggingEventBuilder create(Logger logger, LogLevel level, Map<String, Object> globalContext, boolean canLogAtLevel) {
        if (canLogAtLevel) {
            return new LoggingEventBuilder(logger, level, globalContext, true);
        }
        return NOOP;
    }

    private LoggingEventBuilder(Logger logger, LogLevel level, Map<String, Object> globalContext, boolean isEnabled) {
        this.logger = logger;
        this.level = level;
        this.isEnabled = isEnabled;
        this.globalContext = globalContext;
        this.hasGlobalContext = !CoreUtils.isNullOrEmpty(globalContext);
    }

    public LoggingEventBuilder addKeyValue(String key, String value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Object value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, boolean value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, long value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Supplier<String> valueSupplier) {
        if (this.isEnabled) {
            if (this.context == null) {
                this.context = new ArrayList<ContextKeyValuePair>();
            }
            this.context.add(new ContextKeyValuePair(key, valueSupplier));
        }
        return this;
    }

    public void log(String message) {
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(message, null), null);
        }
    }

    public void log(Supplier<String> messageSupplier) {
        if (this.isEnabled) {
            String message = messageSupplier != null ? messageSupplier.get() : null;
            this.performLogging(this.level, this.getMessageWithContext(message, null), null);
        }
    }

    public void log(Supplier<String> messageSupplier, Throwable throwable) {
        if (this.isEnabled) {
            String message = messageSupplier != null ? messageSupplier.get() : null;
            this.performLogging(this.level, this.getMessageWithContext(message, throwable), this.logger.isDebugEnabled() ? throwable : null);
        }
    }

    public void log(String format, Object ... args2) {
        if (this.isEnabled) {
            this.performLogging(this.level, format, args2);
        }
    }

    public Throwable log(Throwable throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(null, throwable), this.logger.isDebugEnabled() ? throwable : null);
        }
        return throwable;
    }

    public RuntimeException log(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(null, runtimeException), this.logger.isDebugEnabled() ? runtimeException : null);
        }
        return runtimeException;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getMessageWithContext(String message, Throwable throwable) {
        if (message == null) {
            message = "";
        }
        try (AccessibleByteArrayOutputStream outputStream2 = new AccessibleByteArrayOutputStream();){
            String string;
            block19: {
                JsonWriter jsonWriter = JsonProviders.createWriter(outputStream2);
                try {
                    jsonWriter.writeStartObject().writeStringField("az.sdk.message", message);
                    if (throwable != null) {
                        jsonWriter.writeNullableField("exception", throwable.getMessage(), JsonWriter::writeString);
                    }
                    if (this.hasGlobalContext) {
                        for (Map.Entry entry : this.globalContext.entrySet()) {
                            jsonWriter.writeUntypedField((String)entry.getKey(), entry.getValue());
                        }
                    }
                    if (this.context != null) {
                        for (ContextKeyValuePair contextKeyValuePair : this.context) {
                            contextKeyValuePair.write(jsonWriter);
                        }
                    }
                    jsonWriter.writeEndObject().flush();
                    string = outputStream2.toString(StandardCharsets.UTF_8);
                    if (jsonWriter == null) break block19;
                }
                catch (Throwable throwable2) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void addKeyValueInternal(String key, Object value) {
        if (this.context == null) {
            this.context = new ArrayList<ContextKeyValuePair>();
        }
        this.context.add(new ContextKeyValuePair(key, value));
    }

    private void performLogging(LogLevel logLevel, String format, Object ... args2) {
        Throwable throwable = null;
        if (LoggingUtils.doesArgsHaveThrowable(args2)) {
            Object throwableObj = args2[args2.length - 1];
            if (throwableObj instanceof Throwable) {
                throwable = (Throwable)throwableObj;
            }
            if (!this.logger.isDebugEnabled()) {
                args2 = LoggingUtils.removeThrowable(args2);
            }
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(format, args2);
        String message = this.getMessageWithContext(tuple.getMessage(), throwable);
        this.performLogging(logLevel, message, tuple.getThrowable());
    }

    private void performLogging(LogLevel logLevel, String message, Throwable throwable) {
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(message, throwable);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(message, throwable);
                break;
            }
            case WARNING: {
                this.logger.warn(message, throwable);
                break;
            }
            case ERROR: {
                this.logger.error(message, throwable);
                break;
            }
        }
    }

    private static final class ContextKeyValuePair {
        private final String key;
        private final Object value;
        private final Supplier<String> valueSupplier;

        ContextKeyValuePair(String key, Object value) {
            this.key = key;
            this.value = value;
            this.valueSupplier = null;
        }

        ContextKeyValuePair(String key, Supplier<String> valueSupplier) {
            this.key = key;
            this.value = null;
            this.valueSupplier = valueSupplier;
        }

        public void write(JsonWriter jsonWriter) throws IOException {
            jsonWriter.writeUntypedField(this.key, this.valueSupplier == null ? this.value : this.valueSupplier.get());
        }
    }
}

