/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.exception.AzureException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.implementation.PollingUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.ObjectSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.time.OffsetDateTime;

public class SyncStatusCheckPollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncStatusCheckPollingStrategy.class);
    private static final ObjectSerializer DEFAULT_SERIALIZER = new DefaultJsonSerializer();
    private final ObjectSerializer serializer;

    public SyncStatusCheckPollingStrategy() {
        this(DEFAULT_SERIALIZER);
    }

    public SyncStatusCheckPollingStrategy(ObjectSerializer serializer) {
        this.serializer = serializer == null ? DEFAULT_SERIALIZER : serializer;
    }

    @Override
    public boolean canPoll(Response<?> initialResponse) {
        return true;
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return new PollResponse<T>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, PollingUtils.convertResponseSync(response.getValue(), this.serializer, pollResponseType), retryAfter);
        }
        throw LOGGER.logExceptionAsError(new AzureException("Operation failed or cancelled: " + response.getStatusCode()));
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> context, TypeReference<T> pollResponseType) {
        throw LOGGER.logExceptionAsError(new IllegalStateException("StatusCheckPollingStrategy doesn't support polling"));
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        T activationResponse = pollingContext.getActivationResponse().getValue();
        return PollingUtils.convertResponseSync(activationResponse, this.serializer, resultType);
    }
}

