/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.ClientAuthenticationException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.ProxyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.SharedExecutorService;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.DeviceCodeInfo;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBase;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IntelliJCacheAccessor;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.MsalToken;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.PowershellManager;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.SynchronizedAccessor;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.VisualStudioCacheAccessor;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ScopeUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonProviders;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.AppTokenProviderParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ClaimsRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IAccount;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IAuthenticationResult;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IClientSecret;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.MsalJsonParsingException;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.PublicClientApplication;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.RefreshTokenParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.SilentParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.TokenProviderResult;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.dataiku.dss.shadelibazure.com.sun.jna.Platform;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class IdentityClient
extends IdentityClientBase {
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessor = new SynchronizedAccessor(() -> this.getPublicClientApplication(isSharedTokenCacheCredential, false));
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessorWithCae = new SynchronizedAccessor(() -> this.getPublicClientApplication(isSharedTokenCacheCredential, true));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor = new SynchronizedAccessor(() -> this.getConfidentialClientApplication(false));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessorWithCae = new SynchronizedAccessor(() -> this.getConfidentialClientApplication(true));
    private final SynchronizedAccessor<ConfidentialClientApplication> aksConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getAksConfidentialClientApplication);
    private final SynchronizedAccessor<ManagedIdentityApplication> managedIdentityMsalApplicationAccessor = new SynchronizedAccessor(this::getManagedIdentityMsalClient);
    private final SynchronizedAccessor<ConfidentialClientApplication> workloadIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getWorkloadIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<String> clientAssertionAccessor;

    IdentityClient(String tenantId, String clientId, String clientSecret, String certificatePath, String clientAssertionFilePath, String resourceId, String objectId, Supplier<String> clientAssertionSupplier, Function<HttpPipeline, String> clientAssertionSupplierWithHttpPipeline, byte[] certificate, String certificatePassword, boolean isSharedTokenCacheCredential, Duration clientAssertionTimeout, IdentityClientOptions options) {
        super(tenantId, clientId, clientSecret, certificatePath, clientAssertionFilePath, resourceId, objectId, clientAssertionSupplier, clientAssertionSupplierWithHttpPipeline, certificate, certificatePassword, isSharedTokenCacheCredential, clientAssertionTimeout, options);
        Duration cacheTimeout = clientAssertionTimeout == null ? Duration.ofMinutes(5L) : clientAssertionTimeout;
        this.clientAssertionAccessor = new SynchronizedAccessor(this::parseClientAssertion, cacheTimeout);
    }

    public Mono<ManagedIdentityApplication> getManagedIdentityMsalClient() {
        return Mono.defer(() -> {
            try {
                return Mono.just(this.getManagedIdentityMsalApplication());
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getConfidentialClientApplication(boolean enableCae) {
        return Mono.defer(() -> {
            try {
                return Mono.just(this.getConfidentialClient(enableCae));
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getAksConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
                IClientSecret credential = ClientCredentialFactory.createFromSecret(this.clientSecret != null ? this.clientSecret : "dummy-secret");
                ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder(this.clientId == null ? "SYSTEM-ASSIGNED-MANAGED-IDENTITY" : this.clientId, credential);
                ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)applicationBuilder.instanceDiscovery(false)).validateAuthority(false)).logPii(this.options.isUnsafeSupportLoggingEnabled());
                try {
                    applicationBuilder = (ConfidentialClientApplication.Builder)applicationBuilder.authority(authorityUrl);
                }
                catch (MalformedURLException e) {
                    throw LOGGER.logExceptionAsWarning(new IllegalStateException(e));
                }
                applicationBuilder.appTokenProvider(appTokenProviderParameters -> {
                    TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList<String>(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
                    Mono<AccessToken> accessTokenAsync = this.authenticateWithExchangeToken(trc);
                    return accessTokenAsync.map(accessToken -> {
                        TokenProviderResult result = new TokenProviderResult();
                        result.setAccessToken(accessToken.getToken());
                        result.setTenantId(trc.getTenantId());
                        result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                        if (accessToken.getRefreshAt() != null) {
                            result.setRefreshInSeconds(accessToken.getRefreshAt().toEpochSecond());
                        }
                        return result;
                    }).toFuture();
                });
                this.initializeHttpPipelineAdapter();
                if (this.httpPipelineAdapter != null) {
                    applicationBuilder.httpClient(this.httpPipelineAdapter);
                } else {
                    applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
                }
                if (this.options.getExecutorService() != null) {
                    applicationBuilder.executorService(this.options.getExecutorService());
                } else {
                    applicationBuilder.executorService(SharedExecutorService.getInstance());
                }
                return Mono.just(applicationBuilder.build());
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getWorkloadIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just(super.getWorkloadIdentityConfidentialClient());
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<String> parseClientAssertion() {
        return Mono.fromCallable(() -> {
            if (this.clientAssertionFilePath != null) {
                byte[] encoded = Files.readAllBytes(Paths.get(this.clientAssertionFilePath, new String[0]));
                return new String(encoded, StandardCharsets.UTF_8);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Client Assertion File Path is not provided. It should be provided to authenticate with client assertion."));
        });
    }

    private Mono<PublicClientApplication> getPublicClientApplication(boolean sharedTokenCacheCredential, boolean enableCae) {
        return Mono.defer(() -> {
            try {
                return Mono.just(this.getPublicClient(sharedTokenCacheCredential, enableCae));
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    public Mono<MsalToken> authenticateWithIntelliJ(TokenRequestContext request) {
        try {
            IntelliJCacheAccessor cacheAccessor = new IntelliJCacheAccessor();
            String cachedRefreshToken = cacheAccessor.getIntelliJCredentialsFromIdentityMsalCache();
            if (!CoreUtils.isNullOrEmpty(cachedRefreshToken)) {
                RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(request.getScopes()), cachedRefreshToken);
                if (request.getClaims() != null) {
                    ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
                    refreshTokenParametersBuilder.claims(claimsRequest);
                }
                return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(pc.acquireToken(refreshTokenParametersBuilder.build())).map(MsalToken::new));
            }
            String exception = "IntelliJ authentication not available. Please login with the Azure Toolkit for IntelliJ. You may also need to upgrade to a newer version of the Azure Toolkit for IntelliJ. This authentication is supported on version 3.53 and higher. Please see https://aka.ms/azsdk/java/identity/intellijcredential/troubleshoot for more information.";
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException(exception)));
        }
        catch (RuntimeException e) {
            return Mono.error(e);
        }
    }

    public Mono<AccessToken> authenticateWithAzureCli(TokenRequestContext request) {
        StringBuilder azCommand = new StringBuilder("az account get-access-token --output json --resource ");
        String scopes = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scopes);
        }
        catch (IllegalArgumentException ex) {
            return Mono.error(LOGGER.logExceptionAsError(ex));
        }
        azCommand.append(scopes);
        try {
            String subscription;
            String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
            ValidationUtil.validateTenantIdCharacterRange(tenant, LOGGER);
            if (!CoreUtils.isNullOrEmpty(tenant) && !tenant.equals("organizations")) {
                azCommand.append(" --tenant ").append(tenant);
            }
            if (!CoreUtils.isNullOrEmpty(subscription = this.options.getSubscription())) {
                azCommand.append(" --subscription \"").append(subscription).append("\"");
            }
        }
        catch (ClientAuthenticationException | IllegalArgumentException e) {
            return Mono.error(e);
        }
        try {
            AccessToken token = this.getTokenFromAzureCLIAuthentication(azCommand);
            return Mono.just(token);
        }
        catch (RuntimeException e) {
            return Mono.error(e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)e) : LOGGER.logExceptionAsError(e));
        }
    }

    public Mono<AccessToken> authenticateWithAzureDeveloperCli(TokenRequestContext request) {
        StringBuilder azdCommand = new StringBuilder("azd auth token --output json --scope ");
        List<String> scopes = request.getScopes();
        if (scopes.size() == 0) {
            return Mono.error(LOGGER.logExceptionAsError(new IllegalArgumentException("Missing scope in request")));
        }
        for (String scope : scopes) {
            try {
                ScopeUtil.validateScope(scope);
            }
            catch (IllegalArgumentException ex) {
                return Mono.error(LOGGER.logExceptionAsError(ex));
            }
        }
        azdCommand.append(String.join((CharSequence)" --scope ", scopes));
        try {
            String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
            ValidationUtil.validateTenantIdCharacterRange(tenant, LOGGER);
            if (!CoreUtils.isNullOrEmpty(tenant) && !tenant.equals("organizations")) {
                azdCommand.append(" --tenant-id ").append(tenant);
            }
        }
        catch (ClientAuthenticationException | IllegalArgumentException e) {
            return Mono.error(e);
        }
        try {
            AccessToken token = this.getTokenFromAzureDeveloperCLIAuthentication(azdCommand);
            return Mono.just(token);
        }
        catch (RuntimeException e) {
            return Mono.error(e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)e) : LOGGER.logExceptionAsError(e));
        }
    }

    public Mono<AccessToken> authenticateWithAzurePowerShell(TokenRequestContext request) {
        ValidationUtil.validateTenantIdCharacterRange(this.tenantId, LOGGER);
        ArrayList exceptions = new ArrayList(2);
        PowershellManager defaultPowerShellManager = new PowershellManager(false);
        PowershellManager legacyPowerShellManager = Platform.isWindows() ? new PowershellManager(true) : null;
        ArrayList<PowershellManager> powershellManagers = new ArrayList<PowershellManager>(2);
        powershellManagers.add(defaultPowerShellManager);
        if (legacyPowerShellManager != null) {
            powershellManagers.add(legacyPowerShellManager);
        }
        return Flux.fromIterable(powershellManagers).flatMap(powershellManager -> this.getAccessTokenFromPowerShell(request, (PowershellManager)powershellManager).onErrorResume(t -> {
            if (!t.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error(new ClientAuthenticationException("Azure Powershell authentication failed. Error Details: " + t.getMessage() + ". To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/powershellcredential/troubleshoot", null, (Throwable)t));
            }
            exceptions.add((CredentialUnavailableException)t);
            return Mono.empty();
        }), 1).next().switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException last = (CredentialUnavailableException)exceptions.get(exceptions.size() - 1);
            for (int z = exceptions.size() - 2; z >= 0; --z) {
                CredentialUnavailableException current = (CredentialUnavailableException)exceptions.get(z);
                last = new CredentialUnavailableException("Azure PowerShell authentication failed using defaultpowershell(pwsh) with following error: " + current.getMessage() + "\r\nAzure PowerShell authentication failed using powershell-core(powershell) with following error: " + last.getMessage(), last.getCause());
            }
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, last));
        }));
    }

    public Mono<AccessToken> authenticateWithOBO(TokenRequestContext request) {
        return this.getConfidentialClientInstance(request).getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> confidentialClient.acquireToken(this.buildOBOFlowParameters(request))).map(MsalToken::new));
    }

    private Mono<AccessToken> getAccessTokenFromPowerShell(TokenRequestContext request, PowershellManager powershellManager) {
        String scope = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scope);
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
        return Mono.defer(() -> {
            String sep = System.lineSeparator();
            String command = "$ErrorActionPreference = 'Stop'" + sep + "[version]$minimumVersion = '2.2.0'" + sep + "" + sep + "$m = Import-Module Az.Accounts -MinimumVersion $minimumVersion -PassThru -ErrorAction SilentlyContinue" + sep + "" + sep + "if (! $m) {" + sep + "    Write-Output 'VersionTooOld'" + sep + "    exit" + sep + "}" + sep + "" + sep + "$useSecureString = $m.Version -ge [version]'2.17.0'" + sep + "" + sep + "$params = @{" + sep + "    'WarningAction'='Ignore'" + sep + "    'ResourceUrl'='" + scope + "'" + sep + "}" + sep + "" + sep + "if ($useSecureString) {" + sep + "    $params['AsSecureString'] = $true" + sep + "}" + sep + "" + sep + "$token = Get-AzAccessToken @params" + sep + "$customToken = New-Object -TypeName psobject" + sep + "" + sep + "$customToken | Add-Member -MemberType NoteProperty -Name Token -Value ($useSecureString -eq $true ? (ConvertFrom-SecureString -AsPlainText $token.Token) : $token.Token)" + sep + "$customToken | Add-Member -MemberType NoteProperty -Name ExpiresOn -Value $token.ExpiresOn" + sep + "" + sep + "return $customToken | ConvertTo-Json";
            return powershellManager.runCommand(command).flatMap(output -> {
                Mono<AccessToken> mono;
                block10: {
                    if (output.contains("VersionTooOld")) {
                        return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Az.Account module with version >= 2.2.0 is not installed. It needs to be installed to use Azure PowerShell Credential.")));
                    }
                    if (output.contains("Run Connect-AzAccount to login")) {
                        return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Run Connect-AzAccount to login to Azure account in PowerShell.")));
                    }
                    JsonReader reader = JsonProviders.createReader(output);
                    try {
                        reader.nextToken();
                        Map<String, String> objectMap = reader.readMap(JsonReader::getString);
                        String accessToken = objectMap.get("Token");
                        String time = objectMap.get("ExpiresOn");
                        OffsetDateTime expiresOn = OffsetDateTime.parse(time).withOffsetSameInstant(ZoneOffset.UTC);
                        mono = Mono.just(new AccessToken(accessToken, expiresOn));
                        if (reader == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Encountered error when deserializing response from Azure Power Shell.", (Throwable)e)));
                        }
                    }
                    reader.close();
                }
                return mono;
            });
        });
    }

    public Mono<AccessToken> authenticateWithConfidentialClient(TokenRequestContext request) {
        return this.getConfidentialClientInstance(request).getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = this.buildConfidentialClientParameters(request);
            return confidentialClient.acquireToken(builder.build());
        })).map(MsalToken::new);
    }

    private SynchronizedAccessor<ConfidentialClientApplication> getConfidentialClientInstance(TokenRequestContext requestContext) {
        return requestContext.isCaeEnabled() ? this.confidentialClientApplicationAccessorWithCae : this.confidentialClientApplicationAccessor;
    }

    private ClientCredentialParameters.ClientCredentialParametersBuilder buildConfidentialClientParameters(TokenRequestContext request) {
        ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (this.clientAssertionSupplier != null) {
            builder.clientCredential(ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplier.get()));
        } else if (this.clientAssertionSupplierWithHttpPipeline != null) {
            builder.clientCredential(ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplierWithHttpPipeline.apply(this.getPipeline())));
        }
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            builder.claims(claimsRequest);
        }
        return builder;
    }

    public Mono<AccessToken> authenticateWithAksConfidentialClient(TokenRequestContext request) {
        return this.aksConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return confidentialClient.acquireToken(builder.build());
        })).onErrorMap(t -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithManagedIdentityMsalClient(TokenRequestContext request) {
        String resource = ScopeUtil.scopesToResource(request.getScopes());
        return Mono.fromSupplier(() -> this.options.isChained() && ManagedIdentitySourceType.DEFAULT_TO_IMDS.equals((Object)ManagedIdentityApplication.getManagedIdentitySource())).flatMap(shouldProbe -> shouldProbe != false ? this.checkIMDSAvailable(this.getImdsEndpoint()) : Mono.just(true)).flatMap(ignored -> this.getTokenFromMsalMIClient(resource));
    }

    private Mono<AccessToken> getTokenFromMsalMIClient(String resource) {
        return this.managedIdentityMsalApplicationAccessor.getValue().flatMap(managedIdentityApplication -> Mono.fromFuture(() -> {
            ManagedIdentityParameters.ManagedIdentityParametersBuilder builder = ManagedIdentityParameters.builder(resource);
            try {
                return managedIdentityApplication.acquireTokenForManagedIdentity(builder.build());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })).onErrorMap(t -> {
            if (this.options.isChained() && t instanceof MsalJsonParsingException) {
                return new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)t);
            }
            return new ClientAuthenticationException("Managed Identity authentication failed, see inner exception for more information.", null, (Throwable)t);
        }).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithWorkloadIdentityConfidentialClient(TokenRequestContext request) {
        return this.workloadIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return confidentialClient.acquireToken(builder.build());
        })).onErrorMap(t -> new CredentialUnavailableException("Workload Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(TokenRequestContext request, String username, String password) {
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> {
            UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = this.buildUsernamePasswordFlowParameters(request, username, password);
            return pc.acquireToken(userNamePasswordParametersBuilder.build());
        })).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with username and password. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/usernamepasswordcredential/troubleshoot", null, (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithPublicClientCache(TokenRequestContext request, IAccount account) {
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(request, (PublicClientApplication)pc, account, false)).map(MsalToken::new).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))).switchIfEmpty(Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(request, (PublicClientApplication)pc, account, true)).map(MsalToken::new)));
    }

    private CompletableFuture<IAuthenticationResult> acquireTokenFromPublicClientSilently(TokenRequestContext request, PublicClientApplication pc, IAccount account, boolean forceRefresh) {
        SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet<String>(request.getScopes()));
        if (forceRefresh) {
            parametersBuilder.forceRefresh(true);
        }
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(claimsRequest);
            parametersBuilder.forceRefresh(true);
        }
        if (account != null) {
            parametersBuilder = parametersBuilder.account(account);
        }
        parametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        try {
            return pc.acquireTokenSilently(parametersBuilder.build());
        }
        catch (MalformedURLException e) {
            return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
        }
    }

    private SynchronizedAccessor<PublicClientApplication> getPublicClientInstance(TokenRequestContext request) {
        return request.isCaeEnabled() ? this.publicClientApplicationAccessorWithCae : this.publicClientApplicationAccessor;
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext request) {
        return this.authenticateWithConfidentialClientCache(request, null);
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext request, IAccount account) {
        return this.getConfidentialClientInstance(request).getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            if (account != null) {
                parametersBuilder.account(account);
            }
            try {
                return confidentialClient.acquireTokenSilently(parametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(ar -> new MsalToken((IAuthenticationResult)ar)).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))));
    }

    public Mono<MsalToken> authenticateWithDeviceCode(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> {
            DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder parametersBuilder = this.buildDeviceCodeFlowParameters(request, deviceCodeConsumer);
            return pc.acquireToken(parametersBuilder.build());
        }).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with device code.", null, (Throwable)t)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithVsCodeCredential(TokenRequestContext request, String cloud) {
        if (this.isADFSTenant()) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("VsCodeCredential  authentication unavailable. ADFS tenant/authorities are not supported. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot")));
        }
        VisualStudioCacheAccessor accessor = new VisualStudioCacheAccessor();
        String credential = null;
        try {
            credential = accessor.getCredentials("VS Code Azure", cloud);
        }
        catch (CredentialUnavailableException e) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, e));
        }
        RefreshTokenParameters.RefreshTokenParametersBuilder parametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(request.getScopes()), credential);
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(claimsRequest);
        }
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(pc.acquireToken(parametersBuilder.build())).onErrorResume(t -> {
            if (t instanceof MsalInteractionRequiredException) {
                return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Failed to acquire token with VS code credential. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot", (Throwable)t)));
            }
            return Mono.error(new ClientAuthenticationException("Failed to acquire token with VS code credential", null, (Throwable)t));
        }).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(TokenRequestContext request, String authorizationCode, URI redirectUrl) {
        Mono acquireToken;
        AuthorizationCodeParameters.AuthorizationCodeParametersBuilder parametersBuilder = AuthorizationCodeParameters.builder(authorizationCode, redirectUrl).scopes(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(claimsRequest);
        }
        if (this.clientSecret != null) {
            acquireToken = this.getConfidentialClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parametersBuilder.build())));
        } else {
            SynchronizedAccessor<PublicClientApplication> publicClient = this.getPublicClientInstance(request);
            acquireToken = publicClient.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parametersBuilder.build())));
        }
        return acquireToken.onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with authorization code", null, (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(TokenRequestContext request, Integer port, String redirectUrl, String loginHint) {
        URI redirectUri;
        String redirect = port != null ? "http://localhost:" + port : (redirectUrl != null ? redirectUrl : "http://localhost");
        try {
            redirectUri = new URI(redirect);
        }
        catch (URISyntaxException e) {
            return Mono.error(LOGGER.logExceptionAsError(new RuntimeException(e)));
        }
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> {
            if (this.options.isBrokerEnabled() && this.options.useDefaultBrokerAccount()) {
                return Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(request, (PublicClientApplication)pc, null, false)).onErrorResume(e -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            InteractiveRequestParameters.InteractiveRequestParametersBuilder builder = this.buildInteractiveRequestParameters(request, loginHint, redirectUri);
            SynchronizedAccessor<PublicClientApplication> publicClient = this.getPublicClientInstance(request);
            return publicClient.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(builder.build())));
        })).onErrorMap(t -> !(t instanceof ClientAuthenticationException), t -> {
            throw new ClientAuthenticationException("Failed to acquire token with Interactive Browser Authentication.", null, (Throwable)t);
        }).map(iAuthenticationResult -> {
            if (this.options.isBrokerEnabled() && request.getProofOfPossessionOptions() != null) {
                return new MsalToken((IAuthenticationResult)iAuthenticationResult, "PoP");
            }
            return new MsalToken((IAuthenticationResult)iAuthenticationResult);
        });
    }

    public Mono<MsalToken> authenticateWithSharedTokenCache(TokenRequestContext request, String username) {
        SynchronizedAccessor<PublicClientApplication> publicClient = this.getPublicClientInstance(request);
        return publicClient.getValue().flatMap(pc -> Mono.fromFuture(pc::getAccounts)).onErrorMap(t -> new CredentialUnavailableException("Cannot get accounts from token cache. Error: " + t.getMessage(), (Throwable)t)).flatMap(set -> {
            HashMap<String, IAccount> accounts = new HashMap<String, IAccount>();
            if (set.isEmpty()) {
                return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("SharedTokenCacheCredential authentication unavailable. No accounts were found in the cache.")));
            }
            for (IAccount cached : set) {
                if (username != null && !username.equals(cached.username())) continue;
                accounts.putIfAbsent(cached.homeAccountId(), cached);
            }
            if (accounts.isEmpty()) {
                return Mono.error(new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. No account matching the specified username: %s was found in the cache.", username)));
            }
            if (accounts.size() > 1) {
                if (username == null) {
                    return Mono.error(new RuntimeException("SharedTokenCacheCredential authentication unavailable. Multiple accounts were found in the cache. Use username and tenant id to disambiguate."));
                }
                return Mono.error(new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. Multiple accounts matching the specified username: %s were found in the cache.", username)));
            }
            IAccount requestedAccount = (IAccount)accounts.values().iterator().next();
            return this.authenticateWithPublicClientCache(request, requestedAccount);
        });
    }

    public Mono<AccessToken> authenticateWithExchangeToken(TokenRequestContext request) {
        return this.clientAssertionAccessor.getValue().flatMap(assertionToken -> Mono.fromCallable(() -> this.authenticateWithExchangeTokenHelper(request, (String)assertionToken)));
    }

    private String getImdsEndpoint() {
        return TRAILING_FORWARD_SLASHES.matcher(this.options.getImdsAuthorityHost()).replaceAll("") + "/metadata/identity/oauth2/token";
    }

    int getRetryTimeoutInMs(int retry) {
        return (int)this.options.getRetryTimeout().apply(Duration.ofSeconds(retry)).toMillis();
    }

    private Mono<Boolean> checkIMDSAvailable(String endpoint) {
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            URL url = IdentityClient.getUrl(endpoint + "?api-version=2018-02-01");
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(1000);
                connection.connect();
            }
            catch (Exception e) {
                throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", (Throwable)e));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return true;
        });
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }

    private CompletableFuture<IAuthenticationResult> getFailedCompletableFuture(Exception e) {
        CompletableFuture<IAuthenticationResult> completableFuture = new CompletableFuture<IAuthenticationResult>();
        completableFuture.completeExceptionally(e);
        return completableFuture;
    }

    public IdentityClientOptions getIdentityClientOptions() {
        return this.options;
    }

    private boolean isADFSTenant() {
        return "adfs".equals(this.tenantId);
    }

    @Override
    Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider() {
        return appTokenProviderParameters -> {
            TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList<String>(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> accessTokenAsync = this.authenticateWithExchangeToken(trc);
            return accessTokenAsync.map(accessToken -> {
                TokenProviderResult result = new TokenProviderResult();
                result.setAccessToken(accessToken.getToken());
                result.setTenantId(trc.getTenantId());
                result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return result;
            }).toFuture();
        };
    }
}

