/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IAccount;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.IAuthenticationResult;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class MsalToken
extends AccessToken {
    private IAuthenticationResult authenticationResult;

    public MsalToken(IAuthenticationResult msalResult) {
        super(msalResult.accessToken(), OffsetDateTime.ofInstant(msalResult.expiresOnDate().toInstant(), ZoneOffset.UTC), msalResult.metadata() != null ? (msalResult.metadata().refreshOn() == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochSecond(msalResult.metadata().refreshOn()), ZoneOffset.UTC)) : null);
        this.authenticationResult = msalResult;
    }

    public MsalToken(IAuthenticationResult msalResult, String tokenType) {
        super(msalResult.accessToken(), OffsetDateTime.ofInstant(msalResult.expiresOnDate().toInstant(), ZoneOffset.UTC), msalResult.metadata() != null ? (msalResult.metadata().refreshOn() == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochSecond(msalResult.metadata().refreshOn()), ZoneOffset.UTC)) : null, tokenType);
        this.authenticationResult = msalResult;
    }

    public IAccount getAccount() {
        return this.authenticationResult.account();
    }

    public IAuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }
}

