/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.AppsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.AppResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ActiveDeploymentCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.AppResourceCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.CustomDomainValidatePayload;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.CustomDomainValidateResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ResourceUploadDefinition;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class AppsClientImpl
implements AppsClient {
    private final AppsService service;
    private final AppPlatformManagementClientImpl client;

    AppsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(AppsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String appName, String syncStatus) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, syncStatus, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AppResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String appName, String syncStatus, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, syncStatus, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppResourceInner> getAsync(String resourceGroupName, String serviceName, String appName) {
        String syncStatus = null;
        return this.getWithResponseAsync(resourceGroupName, serviceName, appName, syncStatus).flatMap(res -> Mono.justOrEmpty((AppResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppResourceInner> getWithResponse(String resourceGroupName, String serviceName, String appName, String syncStatus, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, appName, syncStatus, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner get(String resourceGroupName, String serviceName, String appName) {
        String syncStatus = null;
        return this.getWithResponse(resourceGroupName, serviceName, appName, syncStatus, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (appResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter appResource is required and cannot be null."));
        }
        appResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, appResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (appResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter appResource is required and cannot be null."));
        }
        appResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, appResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AppResourceInner>, AppResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, appResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AppResourceInner.class), (Type)((Object)AppResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AppResourceInner>, AppResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, appResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AppResourceInner.class), (Type)((Object)AppResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AppResourceInner>, AppResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, appResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AppResourceInner>, AppResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, appResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, appResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AppResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, appResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner createOrUpdate(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, appName, appResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner createOrUpdate(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, appName, appResource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String appName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String appName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String appName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, appName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String appName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, appName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String appName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String appName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName) {
        this.deleteAsync(resourceGroupName, serviceName, appName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, appName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (appResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter appResource is required and cannot be null."));
        }
        appResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, appResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (appResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter appResource is required and cannot be null."));
        }
        appResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, appResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AppResourceInner>, AppResourceInner> beginUpdateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, appName, appResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AppResourceInner.class), (Type)((Object)AppResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AppResourceInner>, AppResourceInner> beginUpdateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, appName, appResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AppResourceInner.class), (Type)((Object)AppResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AppResourceInner>, AppResourceInner> beginUpdate(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, appResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AppResourceInner>, AppResourceInner> beginUpdate(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, appResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppResourceInner> updateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, appResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AppResourceInner> updateAsync(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, appResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner update(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource) {
        return this.updateAsync(resourceGroupName, serviceName, appName, appResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner update(String resourceGroupName, String serviceName, String appName, AppResourceInner appResource, Context context) {
        return this.updateAsync(resourceGroupName, serviceName, appName, appResource, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, AppResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppResourceCollection)res.getValue()).value(), ((AppResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context).map(res -> new PagedResponseBase<Object, AppResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppResourceCollection)res.getValue()).value(), ((AppResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AppResourceInner> listAsync(String resourceGroupName, String serviceName) {
        return new PagedFlux<AppResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AppResourceInner> listAsync(String resourceGroupName, String serviceName, Context context) {
        return new PagedFlux<AppResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppResourceInner> list(String resourceGroupName, String serviceName) {
        return new PagedIterable<AppResourceInner>(this.listAsync(resourceGroupName, serviceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppResourceInner> list(String resourceGroupName, String serviceName, Context context) {
        return new PagedIterable<AppResourceInner>(this.listAsync(resourceGroupName, serviceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceUploadDefinition>> getResourceUploadUrlWithResponseAsync(String resourceGroupName, String serviceName, String appName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceUploadUrl(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceUploadDefinition>> getResourceUploadUrlWithResponseAsync(String resourceGroupName, String serviceName, String appName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getResourceUploadUrl(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceUploadDefinition> getResourceUploadUrlAsync(String resourceGroupName, String serviceName, String appName) {
        return this.getResourceUploadUrlWithResponseAsync(resourceGroupName, serviceName, appName).flatMap(res -> Mono.justOrEmpty((ResourceUploadDefinition)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceUploadDefinition> getResourceUploadUrlWithResponse(String resourceGroupName, String serviceName, String appName, Context context) {
        return this.getResourceUploadUrlWithResponseAsync(resourceGroupName, serviceName, appName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceUploadDefinition getResourceUploadUrl(String resourceGroupName, String serviceName, String appName) {
        return this.getResourceUploadUrlWithResponse(resourceGroupName, serviceName, appName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> setActiveDeploymentsWithResponseAsync(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (activeDeploymentCollection == null) {
            return Mono.error(new IllegalArgumentException("Parameter activeDeploymentCollection is required and cannot be null."));
        }
        activeDeploymentCollection.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setActiveDeployments(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, activeDeploymentCollection, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> setActiveDeploymentsWithResponseAsync(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (activeDeploymentCollection == null) {
            return Mono.error(new IllegalArgumentException("Parameter activeDeploymentCollection is required and cannot be null."));
        }
        activeDeploymentCollection.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setActiveDeployments(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, activeDeploymentCollection, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AppResourceInner>, AppResourceInner> beginSetActiveDeploymentsAsync(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.setActiveDeploymentsWithResponseAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AppResourceInner.class), (Type)((Object)AppResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AppResourceInner>, AppResourceInner> beginSetActiveDeploymentsAsync(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.setActiveDeploymentsWithResponseAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AppResourceInner.class), (Type)((Object)AppResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AppResourceInner>, AppResourceInner> beginSetActiveDeployments(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection) {
        return this.beginSetActiveDeploymentsAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AppResourceInner>, AppResourceInner> beginSetActiveDeployments(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection, Context context) {
        return this.beginSetActiveDeploymentsAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppResourceInner> setActiveDeploymentsAsync(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection) {
        return this.beginSetActiveDeploymentsAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AppResourceInner> setActiveDeploymentsAsync(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection, Context context) {
        return this.beginSetActiveDeploymentsAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner setActiveDeployments(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection) {
        return this.setActiveDeploymentsAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppResourceInner setActiveDeployments(String resourceGroupName, String serviceName, String appName, ActiveDeploymentCollection activeDeploymentCollection, Context context) {
        return this.setActiveDeploymentsAsync(resourceGroupName, serviceName, appName, activeDeploymentCollection, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CustomDomainValidateResult>> validateDomainWithResponseAsync(String resourceGroupName, String serviceName, String appName, CustomDomainValidatePayload validatePayload) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (validatePayload == null) {
            return Mono.error(new IllegalArgumentException("Parameter validatePayload is required and cannot be null."));
        }
        validatePayload.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateDomain(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, validatePayload, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CustomDomainValidateResult>> validateDomainWithResponseAsync(String resourceGroupName, String serviceName, String appName, CustomDomainValidatePayload validatePayload, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (validatePayload == null) {
            return Mono.error(new IllegalArgumentException("Parameter validatePayload is required and cannot be null."));
        }
        validatePayload.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateDomain(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, validatePayload, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainValidateResult> validateDomainAsync(String resourceGroupName, String serviceName, String appName, CustomDomainValidatePayload validatePayload) {
        return this.validateDomainWithResponseAsync(resourceGroupName, serviceName, appName, validatePayload).flatMap(res -> Mono.justOrEmpty((CustomDomainValidateResult)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomDomainValidateResult> validateDomainWithResponse(String resourceGroupName, String serviceName, String appName, CustomDomainValidatePayload validatePayload, Context context) {
        return this.validateDomainWithResponseAsync(resourceGroupName, serviceName, appName, validatePayload, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainValidateResult validateDomain(String resourceGroupName, String serviceName, String appName, CustomDomainValidatePayload validatePayload) {
        return this.validateDomainWithResponse(resourceGroupName, serviceName, appName, validatePayload, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, AppResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppResourceCollection)res.getValue()).value(), ((AppResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, AppResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppResourceCollection)res.getValue()).value(), ((AppResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface AppsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AppResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @QueryParam(value="syncStatus") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @BodyParam(value="application/json") AppResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @BodyParam(value="application/json") AppResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AppResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/getResourceUploadUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceUploadDefinition>> getResourceUploadUrl(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/setActiveDeployments")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> setActiveDeployments(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @BodyParam(value="application/json") ActiveDeploymentCollection var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/validateDomain")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainValidateResult>> validateDomain(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @BodyParam(value="application/json") CustomDomainValidatePayload var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AppResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

