/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.AppServicePlanProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.KubeEnvironmentProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.SkuDescription;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StatusOptions;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class AppServicePlanInner
extends Resource {
    private AppServicePlanProperties innerProperties;
    private SkuDescription sku;
    private ExtendedLocation extendedLocation;
    private String kind;
    private String type;
    private String name;
    private String id;

    private AppServicePlanProperties innerProperties() {
        return this.innerProperties;
    }

    public SkuDescription sku() {
        return this.sku;
    }

    public AppServicePlanInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public AppServicePlanInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public AppServicePlanInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public AppServicePlanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public AppServicePlanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String workerTierName() {
        return this.innerProperties() == null ? null : this.innerProperties().workerTierName();
    }

    public AppServicePlanInner withWorkerTierName(String workerTierName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withWorkerTierName(workerTierName);
        return this;
    }

    public StatusOptions status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironmentProfile();
    }

    public AppServicePlanInner withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withHostingEnvironmentProfile(hostingEnvironmentProfile);
        return this;
    }

    public Integer maximumNumberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfWorkers();
    }

    public Integer numberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfWorkers();
    }

    public String geoRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().geoRegion();
    }

    public Boolean perSiteScaling() {
        return this.innerProperties() == null ? null : this.innerProperties().perSiteScaling();
    }

    public AppServicePlanInner withPerSiteScaling(Boolean perSiteScaling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withPerSiteScaling(perSiteScaling);
        return this;
    }

    public Boolean elasticScaleEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticScaleEnabled();
    }

    public AppServicePlanInner withElasticScaleEnabled(Boolean elasticScaleEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withElasticScaleEnabled(elasticScaleEnabled);
        return this;
    }

    public Integer maximumElasticWorkerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumElasticWorkerCount();
    }

    public AppServicePlanInner withMaximumElasticWorkerCount(Integer maximumElasticWorkerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withMaximumElasticWorkerCount(maximumElasticWorkerCount);
        return this;
    }

    public Integer numberOfSites() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfSites();
    }

    public Boolean isSpot() {
        return this.innerProperties() == null ? null : this.innerProperties().isSpot();
    }

    public AppServicePlanInner withIsSpot(Boolean isSpot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withIsSpot(isSpot);
        return this;
    }

    public OffsetDateTime spotExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().spotExpirationTime();
    }

    public AppServicePlanInner withSpotExpirationTime(OffsetDateTime spotExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withSpotExpirationTime(spotExpirationTime);
        return this;
    }

    public OffsetDateTime freeOfferExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().freeOfferExpirationTime();
    }

    public AppServicePlanInner withFreeOfferExpirationTime(OffsetDateTime freeOfferExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withFreeOfferExpirationTime(freeOfferExpirationTime);
        return this;
    }

    public String resourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGroup();
    }

    public Boolean reserved() {
        return this.innerProperties() == null ? null : this.innerProperties().reserved();
    }

    public AppServicePlanInner withReserved(Boolean reserved) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withReserved(reserved);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public AppServicePlanInner withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public Boolean hyperV() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperV();
    }

    public AppServicePlanInner withHyperV(Boolean hyperV) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withHyperV(hyperV);
        return this;
    }

    public Integer targetWorkerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().targetWorkerCount();
    }

    public AppServicePlanInner withTargetWorkerCount(Integer targetWorkerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withTargetWorkerCount(targetWorkerCount);
        return this;
    }

    public Integer targetWorkerSizeId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetWorkerSizeId();
    }

    public AppServicePlanInner withTargetWorkerSizeId(Integer targetWorkerSizeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withTargetWorkerSizeId(targetWorkerSizeId);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public KubeEnvironmentProfile kubeEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().kubeEnvironmentProfile();
    }

    public AppServicePlanInner withKubeEnvironmentProfile(KubeEnvironmentProfile kubeEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withKubeEnvironmentProfile(kubeEnvironmentProfile);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public AppServicePlanInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static AppServicePlanInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServicePlanInner deserializedAppServicePlanInner = new AppServicePlanInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppServicePlanInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppServicePlanInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppServicePlanInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAppServicePlanInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAppServicePlanInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppServicePlanInner.innerProperties = AppServicePlanProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAppServicePlanInner.sku = SkuDescription.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedAppServicePlanInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAppServicePlanInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServicePlanInner;
        });
    }
}

