/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContainerAppProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Template;
import java.io.IOException;

public final class ContainerAppProperties
implements JsonSerializable<ContainerAppProperties> {
    private ContainerAppProvisioningState provisioningState;
    private String kubeEnvironmentId;
    private String latestRevisionName;
    private String latestRevisionFqdn;
    private Configuration configuration;
    private Template template;

    public ContainerAppProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String kubeEnvironmentId() {
        return this.kubeEnvironmentId;
    }

    public ContainerAppProperties withKubeEnvironmentId(String kubeEnvironmentId) {
        this.kubeEnvironmentId = kubeEnvironmentId;
        return this;
    }

    public String latestRevisionName() {
        return this.latestRevisionName;
    }

    public String latestRevisionFqdn() {
        return this.latestRevisionFqdn;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public ContainerAppProperties withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Template template() {
        return this.template;
    }

    public ContainerAppProperties withTemplate(Template template) {
        this.template = template;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.template() != null) {
            this.template().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubeEnvironmentId", this.kubeEnvironmentId);
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeJsonField("template", this.template);
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppProperties deserializedContainerAppProperties = new ContainerAppProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerAppProperties.provisioningState = ContainerAppProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("kubeEnvironmentId".equals(fieldName)) {
                    deserializedContainerAppProperties.kubeEnvironmentId = reader.getString();
                    continue;
                }
                if ("latestRevisionName".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionName = reader.getString();
                    continue;
                }
                if ("latestRevisionFqdn".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionFqdn = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedContainerAppProperties.configuration = Configuration.fromJson(reader);
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedContainerAppProperties.template = Template.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppProperties;
        });
    }
}

