/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContentLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OperationResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RepetitionIndex;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RetryHistory;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class WorkflowRunActionRepetitionProperties
extends OperationResult {
    private List<RepetitionIndex> repetitionIndexes;
    private Object trackedProperties;
    private ContentLink outputsLink;
    private Object outputs;
    private ContentLink inputsLink;
    private Object inputs;
    private String trackingId;

    public List<RepetitionIndex> repetitionIndexes() {
        return this.repetitionIndexes;
    }

    public WorkflowRunActionRepetitionProperties withRepetitionIndexes(List<RepetitionIndex> repetitionIndexes) {
        this.repetitionIndexes = repetitionIndexes;
        return this;
    }

    @Override
    public Object trackedProperties() {
        return this.trackedProperties;
    }

    @Override
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    @Override
    public Object outputs() {
        return this.outputs;
    }

    @Override
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    @Override
    public Object inputs() {
        return this.inputs;
    }

    @Override
    public String trackingId() {
        return this.trackingId;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withRetryHistory(List<RetryHistory> retryHistory) {
        super.withRetryHistory(retryHistory);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withIterationCount(Integer iterationCount) {
        super.withIterationCount(iterationCount);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withCorrelation(RunActionCorrelation correlation) {
        super.withCorrelation(correlation);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withStatus(WorkflowStatus status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withCode(String code) {
        super.withCode(code);
        return this;
    }

    @Override
    public WorkflowRunActionRepetitionProperties withError(Object error) {
        super.withError(error);
        return this;
    }

    @Override
    public void validate() {
        if (this.repetitionIndexes() != null) {
            this.repetitionIndexes().forEach(e -> e.validate());
        }
        if (this.correlation() != null) {
            this.correlation().validate();
        }
        if (this.inputsLink() != null) {
            this.inputsLink().validate();
        }
        if (this.outputsLink() != null) {
            this.outputsLink().validate();
        }
        if (this.retryHistory() != null) {
            this.retryHistory().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime()));
        jsonWriter.writeStringField("endTime", this.endTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime()));
        jsonWriter.writeJsonField("correlation", this.correlation());
        jsonWriter.writeStringField("status", this.status() == null ? null : this.status().toString());
        jsonWriter.writeStringField("code", this.code());
        jsonWriter.writeUntypedField("error", this.error());
        jsonWriter.writeArrayField("retryHistory", this.retryHistory(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("iterationCount", this.iterationCount());
        jsonWriter.writeArrayField("repetitionIndexes", this.repetitionIndexes, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static WorkflowRunActionRepetitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunActionRepetitionProperties deserializedWorkflowRunActionRepetitionProperties = new WorkflowRunActionRepetitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withStartTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withEndTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withCorrelation(RunActionCorrelation.fromJson(reader));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withStatus(WorkflowStatus.fromString(reader.getString()));
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withCode(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withError(reader.readUntyped());
                    continue;
                }
                if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.trackingId = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.inputs = reader.readUntyped();
                    continue;
                }
                if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.inputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.outputs = reader.readUntyped();
                    continue;
                }
                if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.outputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("trackedProperties".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.trackedProperties = reader.readUntyped();
                    continue;
                }
                if ("retryHistory".equals(fieldName)) {
                    List<RetryHistory> retryHistory = reader.readArray(reader1 -> RetryHistory.fromJson(reader1));
                    deserializedWorkflowRunActionRepetitionProperties.withRetryHistory((List)retryHistory);
                    continue;
                }
                if ("iterationCount".equals(fieldName)) {
                    deserializedWorkflowRunActionRepetitionProperties.withIterationCount(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("repetitionIndexes".equals(fieldName)) {
                    List<RepetitionIndex> repetitionIndexes = reader.readArray(reader1 -> RepetitionIndex.fromJson(reader1));
                    deserializedWorkflowRunActionRepetitionProperties.repetitionIndexes = repetitionIndexes;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowRunActionRepetitionProperties;
        });
    }
}

