/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.serializer.SerializerFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerEncoding;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServiceBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.DeploymentSlotsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.HttpFluxBBResponse;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CsmDeploymentStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DeployOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DeployType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DeploymentSlots;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.KuduDeploymentResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.PricingTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RuntimeStack;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebApp;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppRuntimeStack;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Objects;

class WebAppImpl
extends AppServiceBaseImpl<WebApp, WebAppImpl, WebApp.DefinitionStages.WithCreate, WebApp.Update>
implements WebApp,
WebApp.Definition,
WebApp.DefinitionStages.ExistingWindowsPlanWithGroup,
WebApp.DefinitionStages.ExistingLinuxPlanWithGroup,
WebApp.Update,
WebApp.UpdateStages.WithCredentials,
WebApp.UpdateStages.WithStartUpCommand {
    private DeploymentSlots deploymentSlots;
    private WebAppRuntimeStack runtimeStackOnWindowsOSToUpdate;

    WebAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, AppServiceManager manager) {
        super(name, innerObject, siteConfig, logConfig, manager);
    }

    @Override
    public WebAppImpl update() {
        this.runtimeStackOnWindowsOSToUpdate = null;
        return (WebAppImpl)super.update();
    }

    @Override
    public DeploymentSlots deploymentSlots() {
        if (this.deploymentSlots == null) {
            this.deploymentSlots = new DeploymentSlotsImpl(this);
        }
        return this.deploymentSlots;
    }

    @Override
    public WebAppImpl withBuiltInImage(RuntimeStack runtimeStack) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withLinuxFxVersion(String.format("%s|%s", runtimeStack.stack(), runtimeStack.version()));
        if (runtimeStack.stack().equals("NODE")) {
            this.siteConfig.withNodeVersion(runtimeStack.version());
        }
        if (runtimeStack.stack().equals("PHP")) {
            this.siteConfig.withPhpVersion(runtimeStack.version());
        }
        if (runtimeStack.stack().equals("DOTNETCORE")) {
            this.siteConfig.withNetFrameworkVersion(runtimeStack.version());
        }
        return this;
    }

    @Override
    protected void cleanUpContainerSettings() {
        if (this.siteConfig != null && this.siteConfig.linuxFxVersion() != null) {
            this.siteConfig.withLinuxFxVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.windowsFxVersion() != null) {
            this.siteConfig.withWindowsFxVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.phpVersion() != null) {
            this.siteConfig.withPhpVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.nodeVersion() != null) {
            this.siteConfig.withNodeVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.pythonVersion() != null) {
            this.siteConfig.withPythonVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.javaVersion() != null) {
            this.siteConfig.withJavaVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.netFrameworkVersion() != null) {
            this.siteConfig.withNetFrameworkVersion("v4.0");
        }
        this.withoutAppSetting("DOCKER_CUSTOM_IMAGE_NAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_URL");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_USERNAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD");
    }

    @Override
    public WebAppImpl withStartUpCommand(String startUpCommand) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAppCommandLine(startUpCommand);
        return this;
    }

    @Override
    public WebAppImpl withExistingWindowsPlan(AppServicePlan appServicePlan) {
        return (WebAppImpl)super.withExistingAppServicePlan(appServicePlan);
    }

    @Override
    public WebAppImpl withExistingLinuxPlan(AppServicePlan appServicePlan) {
        return (WebAppImpl)super.withExistingAppServicePlan(appServicePlan);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(OperatingSystem.WINDOWS, pricingTier);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(String appServicePlanName, PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanName, OperatingSystem.WINDOWS, pricingTier);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanCreatable);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(String appServicePlanName, PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanName, OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanCreatable);
    }

    @Override
    public WebAppImpl withRuntimeStack(WebAppRuntimeStack runtimeStack) {
        this.runtimeStackOnWindowsOSToUpdate = runtimeStack;
        return this;
    }

    @Override
    public Mono<Void> warDeployAsync(File warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(File warFile) {
        this.warDeployAsync(warFile).block();
    }

    @Override
    public Mono<Void> warDeployAsync(InputStream warFile, long length) {
        return this.warDeployAsync(warFile, length, null);
    }

    @Override
    public void warDeploy(InputStream warFile, long length) {
        this.warDeployAsync(warFile, length).block();
    }

    @Override
    public Mono<Void> warDeployAsync(File warFile, String appName) {
        try {
            return this.kuduClient.warDeployAsync(warFile, appName);
        }
        catch (IOException e) {
            return Mono.error(e);
        }
    }

    @Override
    public void warDeploy(File warFile, String appName) {
        this.warDeployAsync(warFile, appName).block();
    }

    @Override
    public void warDeploy(InputStream warFile, long length, String appName) {
        this.warDeployAsync(warFile, length, appName).block();
    }

    @Override
    public Mono<Void> warDeployAsync(InputStream warFile, long length, String appName) {
        return this.kuduClient.warDeployAsync(warFile, length, appName);
    }

    @Override
    public Mono<Void> zipDeployAsync(File zipFile) {
        try {
            return this.kuduClient.zipDeployAsync(zipFile);
        }
        catch (IOException e) {
            return Mono.error(e);
        }
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).block();
    }

    @Override
    public Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        return this.kuduClient.zipDeployAsync(zipFile, length).then(this.stopAsync()).then(this.startAsync());
    }

    @Override
    public void zipDeploy(InputStream zipFile, long length) {
        this.zipDeployAsync(zipFile, length).block();
    }

    @Override
    Mono<Indexable> submitMetadata() {
        Mono<Indexable> observable2 = super.submitMetadata();
        if (this.runtimeStackOnWindowsOSToUpdate != null) {
            observable2 = observable2.then(this.listMetadata()).switchIfEmpty(Mono.just(new StringDictionaryInner())).flatMap(stringDictionaryInner -> {
                if (stringDictionaryInner.properties() == null) {
                    stringDictionaryInner.withProperties(new HashMap<String, String>());
                }
                stringDictionaryInner.properties().put("CURRENT_STACK", this.runtimeStackOnWindowsOSToUpdate.runtime());
                return this.updateMetadata((StringDictionaryInner)stringDictionaryInner);
            }).then(Mono.fromCallable(() -> {
                this.runtimeStackOnWindowsOSToUpdate = null;
                return this;
            }));
        }
        return observable2;
    }

    Mono<StringDictionaryInner> listMetadata() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listMetadataAsync(this.resourceGroupName(), this.name());
    }

    Mono<StringDictionaryInner> updateMetadata(StringDictionaryInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateMetadataAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    public void deploy(DeployType type, File file) {
        this.deployAsync(type, file).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, File file) {
        return this.deployAsync(type, file, new DeployOptions());
    }

    @Override
    public void deploy(DeployType type, File file, DeployOptions deployOptions) {
        this.deployAsync(type, file, deployOptions).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, File file, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        try {
            return this.kuduClient.deployAsync(type, file, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment());
        }
        catch (IOException e) {
            return Mono.error(e);
        }
    }

    @Override
    public void deploy(DeployType type, InputStream file, long length) {
        this.deployAsync(type, file, length).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, InputStream file, long length) {
        return this.deployAsync(type, file, length, new DeployOptions());
    }

    @Override
    public void deploy(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        this.deployAsync(type, file, length, deployOptions).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        return this.kuduClient.deployAsync(type, file, length, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment());
    }

    @Override
    public KuduDeploymentResult pushDeploy(DeployType type, File file, DeployOptions deployOptions) {
        return this.pushDeployAsync(type, file, deployOptions).block();
    }

    @Override
    public Mono<KuduDeploymentResult> pushDeployAsync(DeployType type, File file, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        try {
            return this.kuduClient.pushDeployAsync(type, file, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment(), deployOptions.trackDeployment());
        }
        catch (IOException e) {
            return Mono.error(e);
        }
    }

    @Override
    public CsmDeploymentStatus getDeploymentStatus(String deploymentId) {
        return this.getDeploymentStatusAsync(deploymentId).block();
    }

    @Override
    public Mono<CsmDeploymentStatus> getDeploymentStatusAsync(String deploymentId) {
        SerializerAdapter serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getProductionSiteDeploymentStatusWithResponseAsync(this.resourceGroupName(), this.name(), deploymentId).flatMap(fluxResponse -> {
            HttpFluxBBResponse response = new HttpFluxBBResponse((Response<Flux<ByteBuffer>>)fluxResponse);
            return ((HttpResponse)response).getBodyAsString().flatMap(bodyString -> {
                CsmDeploymentStatus status;
                try {
                    status = (CsmDeploymentStatus)serializerAdapter.deserialize((String)bodyString, (Type)((Object)CsmDeploymentStatus.class), SerializerEncoding.JSON);
                }
                catch (IOException e) {
                    return Mono.error(new ManagementException("Deserialize failed for response body.", response));
                }
                return Mono.justOrEmpty(status);
            }).doFinally(ignored -> response.close());
        });
    }
}

