/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppInsightsWebAppStackSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.GitHubActionWebAppStackSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.SiteConfigPropertiesDictionary;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FunctionAppRuntimeSettings
implements JsonSerializable<FunctionAppRuntimeSettings> {
    private String runtimeVersion;
    private Boolean remoteDebuggingSupported;
    private AppInsightsWebAppStackSettings appInsightsSettings;
    private GitHubActionWebAppStackSettings gitHubActionSettings;
    private Map<String, String> appSettingsDictionary;
    private SiteConfigPropertiesDictionary siteConfigPropertiesDictionary;
    private List<String> supportedFunctionsExtensionVersions;
    private Boolean isPreview;
    private Boolean isDeprecated;
    private Boolean isHidden;
    private OffsetDateTime endOfLifeDate;
    private Boolean isAutoUpdate;
    private Boolean isEarlyAccess;
    private Boolean isDefault;

    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public Boolean remoteDebuggingSupported() {
        return this.remoteDebuggingSupported;
    }

    public AppInsightsWebAppStackSettings appInsightsSettings() {
        return this.appInsightsSettings;
    }

    public GitHubActionWebAppStackSettings gitHubActionSettings() {
        return this.gitHubActionSettings;
    }

    public Map<String, String> appSettingsDictionary() {
        return this.appSettingsDictionary;
    }

    public SiteConfigPropertiesDictionary siteConfigPropertiesDictionary() {
        return this.siteConfigPropertiesDictionary;
    }

    public List<String> supportedFunctionsExtensionVersions() {
        return this.supportedFunctionsExtensionVersions;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public Boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    public Boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public void validate() {
        if (this.appInsightsSettings() != null) {
            this.appInsightsSettings().validate();
        }
        if (this.gitHubActionSettings() != null) {
            this.gitHubActionSettings().validate();
        }
        if (this.siteConfigPropertiesDictionary() != null) {
            this.siteConfigPropertiesDictionary().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static FunctionAppRuntimeSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionAppRuntimeSettings deserializedFunctionAppRuntimeSettings = new FunctionAppRuntimeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runtimeVersion".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.runtimeVersion = reader.getString();
                    continue;
                }
                if ("remoteDebuggingSupported".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.remoteDebuggingSupported = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appInsightsSettings".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.appInsightsSettings = AppInsightsWebAppStackSettings.fromJson(reader);
                    continue;
                }
                if ("gitHubActionSettings".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.gitHubActionSettings = GitHubActionWebAppStackSettings.fromJson(reader);
                    continue;
                }
                if ("appSettingsDictionary".equals(fieldName)) {
                    Map<String, String> appSettingsDictionary = reader.readMap(reader1 -> reader1.getString());
                    deserializedFunctionAppRuntimeSettings.appSettingsDictionary = appSettingsDictionary;
                    continue;
                }
                if ("siteConfigPropertiesDictionary".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.siteConfigPropertiesDictionary = SiteConfigPropertiesDictionary.fromJson(reader);
                    continue;
                }
                if ("supportedFunctionsExtensionVersions".equals(fieldName)) {
                    List<String> supportedFunctionsExtensionVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedFunctionAppRuntimeSettings.supportedFunctionsExtensionVersions = supportedFunctionsExtensionVersions;
                    continue;
                }
                if ("isPreview".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isPreview = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDeprecated".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isDeprecated = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHidden".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isHidden = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.endOfLifeDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("isAutoUpdate".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isAutoUpdate = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isEarlyAccess".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isEarlyAccess = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isDefault = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFunctionAppRuntimeSettings;
        });
    }
}

