/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionApp;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class FunctionAuthenticationPolicy
implements HttpPipelinePolicy {
    private final FunctionApp functionApp;
    private static final String HEADER_NAME = "x-functions-key";
    private String masterKey;

    public FunctionAuthenticationPolicy(FunctionApp functionApp) {
        this.functionApp = functionApp;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Mono<String> masterKeyMono = this.masterKey == null ? this.functionApp.getMasterKeyAsync().map(key -> {
            this.masterKey = key;
            return key;
        }) : Mono.just(this.masterKey);
        return masterKeyMono.flatMap(key -> {
            context.getHttpRequest().setHeader(HEADER_NAME, (String)key);
            return next.process();
        });
    }
}

