/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.AuthorizationManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.MicrosoftGraphClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ActiveDirectoryGroupsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ActiveDirectoryUsersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.RoleAssignmentsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.RoleDefinitionsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ServicePrincipalsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryApplications;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryUsers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignments;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleDefinitions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ServicePrincipals;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.HasServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Objects;

public final class AuthorizationManager
implements HasServiceClient<MicrosoftGraphClient> {
    private final String tenantId;
    private final AzureEnvironment environment;
    private ResourceManagerUtils.InternalRuntimeContext internalContext;
    private final MicrosoftGraphClient microsoftGraphClient;
    private final AuthorizationManagementClient authorizationManagementClient;
    private ActiveDirectoryUsers activeDirectoryUsers;
    private ActiveDirectoryGroups activeDirectoryGroups;
    private ServicePrincipals servicePrincipals;
    private ActiveDirectoryApplications applications;
    private RoleAssignments roleAssignments;
    private RoleDefinitions roleDefinitions;
    private static final String DEFAULT_GRAPH_ENDPOINT_SUFFIX = "v1.0";

    public static AuthorizationManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return AuthorizationManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static AuthorizationManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AuthorizationManager(httpPipeline, profile);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    @Override
    public MicrosoftGraphClient serviceClient() {
        return this.microsoftGraphClient;
    }

    private AuthorizationManager(HttpPipeline httpPipeline, AzureProfile profile) {
        String graphEndpoint = profile.getEnvironment().getMicrosoftGraphEndpoint();
        graphEndpoint = graphEndpoint.endsWith("/") ? graphEndpoint + DEFAULT_GRAPH_ENDPOINT_SUFFIX : graphEndpoint + "/" + DEFAULT_GRAPH_ENDPOINT_SUFFIX;
        this.microsoftGraphClient = new MicrosoftGraphClientBuilder().pipeline(httpPipeline).endpoint(graphEndpoint).buildClient();
        this.authorizationManagementClient = new AuthorizationManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient();
        this.tenantId = profile.getTenantId();
        this.environment = profile.getEnvironment();
    }

    public AuthorizationManagementClient roleServiceClient() {
        return this.authorizationManagementClient;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public AzureEnvironment environment() {
        return this.environment;
    }

    public ResourceManagerUtils.InternalRuntimeContext internalContext() {
        if (this.internalContext == null) {
            this.internalContext = new ResourceManagerUtils.InternalRuntimeContext();
        }
        return this.internalContext;
    }

    public ActiveDirectoryUsers users() {
        if (this.activeDirectoryUsers == null) {
            this.activeDirectoryUsers = new ActiveDirectoryUsersImpl(this);
        }
        return this.activeDirectoryUsers;
    }

    public ActiveDirectoryGroups groups() {
        if (this.activeDirectoryGroups == null) {
            this.activeDirectoryGroups = new ActiveDirectoryGroupsImpl(this);
        }
        return this.activeDirectoryGroups;
    }

    public ServicePrincipals servicePrincipals() {
        if (this.servicePrincipals == null) {
            this.servicePrincipals = new ServicePrincipalsImpl(this);
        }
        return this.servicePrincipals;
    }

    public ActiveDirectoryApplications applications() {
        if (this.applications == null) {
            this.applications = new ActiveDirectoryApplicationsImpl(this);
        }
        return this.applications;
    }

    public RoleAssignments roleAssignments() {
        if (this.roleAssignments == null) {
            this.roleAssignments = new RoleAssignmentsImpl(this);
        }
        return this.roleAssignments;
    }

    public RoleDefinitions roleDefinitions() {
        if (this.roleDefinitions == null) {
            this.roleDefinitions = new RoleDefinitionsImpl(this);
        }
        return this.roleDefinitions;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public AuthorizationManager authenticate(TokenCredential credential, AzureProfile profile) {
            return AuthorizationManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public AuthorizationManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

