/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddPasswordRequestBodyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.CertificateCredentialImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.PasswordCredentialImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.RetryUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroup;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.util.retry.Retry;
import com.dataiku.dss.shadelibazure.reactor.util.retry.RetryBackoffSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ServicePrincipalImpl
extends CreatableUpdatableImpl<ServicePrincipal, MicrosoftGraphServicePrincipalInner, ServicePrincipalImpl>
implements ServicePrincipal,
ServicePrincipal.Definition,
ServicePrincipal.Update,
HasCredential<ServicePrincipalImpl> {
    private AuthorizationManager manager;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;
    private Map<String, RoleAssignment> cachedRoleAssignments;
    private Creatable<ActiveDirectoryApplication> applicationCreatable;
    private Map<String, BuiltInRole> rolesToCreate;
    private Set<String> rolesToDelete;
    String assignedSubscription;
    private List<CertificateCredentialImpl<?>> certificateCredentialsToCreate;
    private List<PasswordCredentialImpl<?>> passwordCredentialsToCreate;

    ServicePrincipalImpl(MicrosoftGraphServicePrincipalInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), innerObject);
        this.manager = manager;
        this.cachedRoleAssignments = new HashMap<String, RoleAssignment>();
        this.rolesToCreate = new HashMap<String, BuiltInRole>();
        this.rolesToDelete = new HashSet<String>();
        this.cachedCertificateCredentials = new HashMap<String, CertificateCredential>();
        this.certificateCredentialsToCreate = new ArrayList();
        this.cachedPasswordCredentials = new HashMap<String, PasswordCredential>();
        this.passwordCredentialsToCreate = new ArrayList();
        this.refreshCredentials(innerObject);
    }

    @Override
    public String applicationId() {
        return ((MicrosoftGraphServicePrincipalInner)this.innerModel()).appId();
    }

    @Override
    public List<String> servicePrincipalNames() {
        return ((MicrosoftGraphServicePrincipalInner)this.innerModel()).servicePrincipalNames();
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    @Override
    public Set<RoleAssignment> roleAssignments() {
        return Collections.unmodifiableSet(new HashSet<RoleAssignment>(this.cachedRoleAssignments.values()));
    }

    @Override
    protected Mono<MicrosoftGraphServicePrincipalInner> getInnerAsync() {
        return this.manager.serviceClient().getServicePrincipalsServicePrincipals().getServicePrincipalAsync(this.id()).doOnSuccess(this::refreshCredentials);
    }

    @Override
    public Mono<ServicePrincipal> createResourceAsync() {
        Mono<Object> sp;
        RetryBackoffSpec retry;
        RetryBackoffSpec retryBackoffSpec = retry = this.isInCreateMode() ? RetryUtils.backoffRetryFor404ResourceNotFound() : null;
        if (this.isInCreateMode()) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAccountEnabled(true);
            if (this.applicationCreatable != null) {
                ActiveDirectoryApplication application = (ActiveDirectoryApplication)this.taskResult(this.applicationCreatable.key());
                ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAppId(application.applicationId());
            }
            sp = this.manager.serviceClient().getServicePrincipalsServicePrincipals().createServicePrincipalAsync((MicrosoftGraphServicePrincipalInner)this.innerModel()).map(this.innerToFluentMap(this));
            if (this.applicationCreatable != null) {
                sp = sp.retryWhen(RetryUtils.backoffRetryFor400BadRequest());
            }
        } else {
            sp = this.manager().serviceClient().getServicePrincipalsServicePrincipals().updateServicePrincipalAsync(this.id(), new MicrosoftGraphServicePrincipalInner().withKeyCredentials(((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials()).withPasswordCredentials(((MicrosoftGraphServicePrincipalInner)this.innerModel()).passwordCredentials())).then(this.refreshAsync());
        }
        return sp.flatMap(servicePrincipal -> this.submitCredentialsAsync((ServicePrincipal)servicePrincipal, retry).mergeWith(this.submitRolesAsync((ServicePrincipal)servicePrincipal)).last()).map(servicePrincipal -> {
            for (PasswordCredentialImpl<?> passwordCredentialImpl : this.passwordCredentialsToCreate) {
                passwordCredentialImpl.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
                passwordCredentialImpl.consumeSecret();
            }
            for (CertificateCredentialImpl certificateCredentialImpl : this.certificateCredentialsToCreate) {
                certificateCredentialImpl.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
            }
            this.passwordCredentialsToCreate.clear();
            this.certificateCredentialsToCreate.clear();
            return servicePrincipal;
        });
    }

    private Mono<ServicePrincipal> submitCredentialsAsync(ServicePrincipal servicePrincipal, Retry retry) {
        return Flux.defer(() -> Flux.fromIterable(this.passwordCredentialsToCreate).flatMap(passwordCredential -> {
            Mono<MicrosoftGraphPasswordCredentialInner> monoAddPassword = this.manager().serviceClient().getServicePrincipals().addPasswordAsync(this.id(), new ServicePrincipalsAddPasswordRequestBodyInner().withPasswordCredential((MicrosoftGraphPasswordCredentialInner)passwordCredential.innerModel()));
            if (retry != null) {
                monoAddPassword = monoAddPassword.retryWhen(retry);
            }
            monoAddPassword = monoAddPassword.doOnNext(passwordCredential::setInner);
            return monoAddPassword;
        })).then(Mono.defer(() -> {
            Mono<ServicePrincipal> monoRefresh = this.refreshAsync();
            if (retry != null) {
                monoRefresh = monoRefresh.retryWhen(retry);
            }
            return monoRefresh;
        }));
    }

    private Mono<ServicePrincipal> submitRolesAsync(ServicePrincipal servicePrincipal) {
        Mono<ServicePrincipal> create = this.rolesToCreate.isEmpty() ? Mono.just(servicePrincipal) : Flux.fromIterable(this.rolesToCreate.entrySet()).flatMap(roleEntry -> ((RoleAssignment.DefinitionStages.Blank)this.manager().roleAssignments().define(this.manager().internalContext().randomUuid())).forServicePrincipal(servicePrincipal).withBuiltInRole((BuiltInRole)roleEntry.getValue()).withScope((String)roleEntry.getKey()).createAsync()).doOnNext(indexable -> this.cachedRoleAssignments.put(indexable.id(), (RoleAssignment)indexable)).last().map(indexable -> {
            this.rolesToCreate.clear();
            return servicePrincipal;
        });
        Mono<ServicePrincipal> delete = this.rolesToDelete.isEmpty() ? Mono.just(servicePrincipal) : Flux.fromIterable(this.rolesToDelete).flatMap(role -> this.manager().roleAssignments().deleteByIdAsync(this.cachedRoleAssignments.get(role).id()).thenReturn(role)).doOnNext(s2 -> this.cachedRoleAssignments.remove(s2)).last().map(s2 -> {
            this.rolesToDelete.clear();
            return servicePrincipal;
        });
        return create.mergeWith(delete).last();
    }

    @Override
    public boolean isInCreateMode() {
        return this.id() == null;
    }

    void refreshCredentials(MicrosoftGraphServicePrincipalInner inner) {
        this.cachedCertificateCredentials.clear();
        this.cachedPasswordCredentials.clear();
        if (inner.keyCredentials() != null) {
            inner.keyCredentials().forEach(keyCredentialInner -> {
                CertificateCredentialImpl certificateCredential = new CertificateCredentialImpl((MicrosoftGraphKeyCredentialInner)keyCredentialInner);
                this.cachedCertificateCredentials.put(certificateCredential.name(), certificateCredential);
            });
        }
        if (inner.passwordCredentials() != null) {
            inner.passwordCredentials().forEach(passwordCredentialInner -> {
                PasswordCredentialImpl passwordCredential = new PasswordCredentialImpl((MicrosoftGraphPasswordCredentialInner)passwordCredentialInner);
                this.cachedPasswordCredentials.put(passwordCredential.name(), passwordCredential);
            });
        }
    }

    @Override
    public Mono<ServicePrincipal> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap(this));
    }

    public CertificateCredentialImpl<ServicePrincipalImpl> defineCertificateCredential(String name) {
        return new CertificateCredentialImpl<ServicePrincipalImpl>(name, this);
    }

    public PasswordCredentialImpl<ServicePrincipalImpl> definePasswordCredential(String name) {
        return new PasswordCredentialImpl<ServicePrincipalImpl>(name, this);
    }

    @Override
    public ServicePrincipalImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name)) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).passwordCredentials().remove(this.cachedPasswordCredentials.get(name).innerModel());
        } else if (this.cachedCertificateCredentials.containsKey(name)) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials().remove(this.cachedCertificateCredentials.get(name).innerModel());
        }
        return this;
    }

    @Override
    public ServicePrincipalImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        this.certificateCredentialsToCreate.add(credential);
        if (((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials() == null) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withKeyCredentials(new ArrayList<MicrosoftGraphKeyCredentialInner>());
        }
        ((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials().add((MicrosoftGraphKeyCredentialInner)credential.innerModel());
        return this;
    }

    @Override
    public ServicePrincipalImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        this.passwordCredentialsToCreate.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(String id) {
        ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAppId(id);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(ActiveDirectoryApplication application) {
        ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAppId(application.applicationId());
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(Creatable<ActiveDirectoryApplication> applicationCreatable) {
        this.addDependency(applicationCreatable);
        this.applicationCreatable = applicationCreatable;
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(String signOnUrl) {
        return this.withNewApplication((Creatable)((ActiveDirectoryApplication.DefinitionStages.Blank)this.manager.applications().define(this.name())).withSignOnUrl(signOnUrl).withIdentifierUrl(signOnUrl));
    }

    @Override
    public ServicePrincipalImpl withNewApplication() {
        return this.withNewApplication((Creatable)this.manager.applications().define(this.name()));
    }

    @Override
    public ServicePrincipalImpl withNewRole(BuiltInRole role, String scope) {
        this.rolesToCreate.put(scope, role);
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewRoleInSubscription(BuiltInRole role, String subscriptionId) {
        this.assignedSubscription = subscriptionId;
        return this.withNewRole(role, "subscriptions/" + subscriptionId);
    }

    @Override
    public ServicePrincipalImpl withNewRoleInResourceGroup(BuiltInRole role, ResourceGroup resourceGroup) {
        return this.withNewRole(role, resourceGroup.id());
    }

    @Override
    public ServicePrincipal.Update withoutRole(RoleAssignment roleAssignment) {
        this.rolesToDelete.add(roleAssignment.id());
        return this;
    }

    @Override
    public String id() {
        return ((MicrosoftGraphServicePrincipalInner)this.innerModel()).id();
    }

    @Override
    public AuthorizationManager manager() {
        return this.manager;
    }
}

