/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MetricsGranularity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MetricsResponseSeriesItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class MetricsResponseInner
implements JsonSerializable<MetricsResponseInner> {
    private OffsetDateTime dateTimeBegin;
    private OffsetDateTime dateTimeEnd;
    private MetricsGranularity granularity;
    private List<MetricsResponseSeriesItem> series;

    public OffsetDateTime dateTimeBegin() {
        return this.dateTimeBegin;
    }

    public MetricsResponseInner withDateTimeBegin(OffsetDateTime dateTimeBegin) {
        this.dateTimeBegin = dateTimeBegin;
        return this;
    }

    public OffsetDateTime dateTimeEnd() {
        return this.dateTimeEnd;
    }

    public MetricsResponseInner withDateTimeEnd(OffsetDateTime dateTimeEnd) {
        this.dateTimeEnd = dateTimeEnd;
        return this;
    }

    public MetricsGranularity granularity() {
        return this.granularity;
    }

    public MetricsResponseInner withGranularity(MetricsGranularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public List<MetricsResponseSeriesItem> series() {
        return this.series;
    }

    public MetricsResponseInner withSeries(List<MetricsResponseSeriesItem> series) {
        this.series = series;
        return this;
    }

    public void validate() {
        if (this.series() != null) {
            this.series().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dateTimeBegin", this.dateTimeBegin == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeBegin));
        jsonWriter.writeStringField("dateTimeEnd", this.dateTimeEnd == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeEnd));
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeArrayField("series", this.series, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricsResponseInner deserializedMetricsResponseInner = new MetricsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateTimeBegin".equals(fieldName)) {
                    deserializedMetricsResponseInner.dateTimeBegin = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("dateTimeEnd".equals(fieldName)) {
                    deserializedMetricsResponseInner.dateTimeEnd = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("granularity".equals(fieldName)) {
                    deserializedMetricsResponseInner.granularity = MetricsGranularity.fromString(reader.getString());
                    continue;
                }
                if ("series".equals(fieldName)) {
                    List<MetricsResponseSeriesItem> series = reader.readArray(reader1 -> MetricsResponseSeriesItem.fromJson(reader1));
                    deserializedMetricsResponseInner.series = series;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricsResponseInner;
        });
    }
}

